const mix = require('laravel-mix');
const theme = process.env.THEME;
const argv = require('yargs').argv;
console.log(theme);
/*
 |--------------------------------------------------------------------------
 | Mix Asset Management
 |--------------------------------------------------------------------------
 |
 | Mix provides a clean, fluent API for defining some Webpack build steps
 | for your Laravel application. By default, we are compiling the Sass
 | file for the application as well as bundling up all the JS files.
 |
 */

   if(argv.env && argv.env == 'admin'){
      console.log('admin process...');
      mix.webpackConfig({
        module: {
            rules: [
              {
                test: /resources[\\\/]lang.+\.(php|json)$/,
                loader: 'laravel-localization-loader',
            },
            ]
        }
      }).scripts(['node_modules/jquery/dist/jquery.min.js','resources/views/management/js/vendor/semantic.min.js'],'public/js/vendor.js')
        .react('resources/views/management/js/starter.js', 'public/js/admin.js')
         .sass('resources/views/management/sass/app.scss', 'public/css/admin.css');
    
    }
    else if(argv.env && argv.env == 'warranty'){
      console.log('warranty ...');
      mix.scripts('resources/views/index/'+ theme +'/modules/page/views/index/landing/warranty/warranty.js', 'public/js/landing/warranty.js');
    }
    else if(argv.env && argv.env == 'amp'){
      console.log('amp ...');
      mix.postCss('resources/views/index/'+ theme +'/sass/amp/base.css', 'public/css/amp-vendor.css') 
          .postCss('resources/views/index/'+ theme +'/sass/amp/grid.css','public/css/amp-vendor.css')
          .postCss('resources/views/index/'+ theme +'/sass/amp/header.css','public/css/amp-vendor.css');
    }
    else if(argv.env && argv.env == 'shop'){
      console.log('shop process ...');
      let item = [];
      item.push('public/js/assets/swiper-bundle.min.js');
      item.push('public/js/assets/toastify-js.js');
      item.push('public/js/assets/autoComplete.min.js');
      item.push('public/js/assets/fancybox.umd.js');

      mix.postCss('resources/views/index/'+ theme +'/sass/amp/base.css', 'public/css/assets/vendor.css') 
          .postCss('resources/views/index/'+ theme +'/sass/amp/grid.css','public/css/assets/vendor.css')
          .sass('resources/views/index/'+ theme +'/sass/amp/app.scss', 'public/css/assets/vendor.css');
          const glob = require('glob');
      (glob.sync('resources/views/index/'+ theme +'/modules/widgets/views/**/*.js') || []).forEach(file => {
            //mix.scripts(file, `public/js/widgets.js`);
            item.push(file);
            // ${file.replace('resources/views/index/goldiran/modules/widgets/views/', '')}
          });
        
          glob.sync('resources/views/index/'+ theme +'/modules/widgets/views/**/*.css' || []).forEach(file => {
            mix.css(file, `public/css/widgets/${file.replace('resources/views/index/'+ theme +'/modules/widgets/views/', '')}`);
          });
          
          mix.scripts(item,'public/js/widgets.js');
          mix.scripts([
            'resources/views/index/'+ theme +'/modules/cart/views/index/*.js',
            'public/js/assets/toastify-js.js',
            'resources/views/index/'+ theme +'/modules/shop/views/index/desktop/*.js',
            'resources/views/index/'+ theme +'/modal.js'],'public/js/shop.js')
          .sass('resources/views/index/'+ theme +'/modules/cart/assets/sass/app.scss','public/css/assets/cart.css');
    }
    else if(argv.env && argv.env == 'request'){
      console.log('request process...');
      mix.webpackConfig({
        module: {
            rules: [
              {
                test: /resources[\\\/]lang.+\.(php|json)$/,
                loader: 'laravel-localization-loader',
            },
            ]
        }
      })//.scripts(['node_modules/jquery/dist/jquery.min.js','resources/views/management/js/vendor/semantic.min.js'],'public/js/vendor.js')
        .js('resources/views/index/goldiran/modules/goldiran/assets/js/request/index.js', 'public/js/request.js').react()
         .sass('resources/views/index/goldiran/modules/goldiran/assets/js/request/sass/app.scss', 'public/css/request.css');
    
    }
	else if(argv.env && argv.env.mode == 'newadmin'){
		// Default
		mix.js('resources/views/newadmin/js/app.js', 'public/admin/js').scripts('resources/views/newadmin/js/config.js', 'public/admin/js/config.js').sass('resources/views/newadmin/sass/app.scss', 'public/admin/css');

		// 3rd party plugins css/js
		mix.sass('resources/views/newadmin/plugins/plugins.scss', 'public/admin/plugins/global/plugins.bundle.css').then(() => {
			// remove unused preprocessed fonts folder
			//rimraf(path.resolve('public/admin/fonts'), () => {});
			//rimraf(path.resolve('public/admin/images'), () => {});
		}).sourceMaps(!mix.inProduction())
			// .setResourceRoot('./')
			.options({processCssUrls: false}).js(['resources/views/newadmin/plugins/plugins.js'], 'public/admin/plugins/global/plugins.bundle.js');

		// Metronic css/js
		mix.sass('resources/views/newadmin/metronic/sass/style.scss', 'public/admin/css/style.bundle.css', {
			sassOptions: {includePaths: ['node_modules']},
		}).js('resources/views/newadmin/js/scripts.js', 'public/admin/js/scripts.bundle.js');

    
    const glob = require('glob');
    // Metronic css pages (single page use)
    (glob.sync('resources/views/newadmin/metronic/sass/pages/**/!(_)*.scss') || []).forEach(file => {
      file = file.replace(/[\\\/]+/g, '/');
      mix.sass(file, file.replace('resources/views/newadmin/metronic/sass', 'public/admin/css').replace(/\.scss$/, '.css'));
    });

    // Metronic theme
    (glob.sync('resources/views/newadmin/metronic/sass/themes/**/!(_)*.scss') || []).forEach(file => {
      file = file.replace(/[\\\/]+/g, '/');
      mix.sass(file, file.replace('resources/views/newadmin/metronic/sass', 'public/admin/css').replace(/\.scss$/, '.css'));
    });
    
    // Custom 3rd party plugins
		(glob.sync('resources/views/newadmin/plugins/custom/**/*.js') || []).forEach(file => {
			mix.js(file, `public/admin/${file.replace('resources/views/newadmin/', '').replace('.js', '.bundle.js')}`);
		});
		(glob.sync('resources/views/newadmin/plugins/custom/**/*.scss') || []).forEach(file => {
			mix.sass(file, `public/admin/${file.replace('resources/views/newadmin/', '').replace('.scss', '.bundle.css')}`);
    });
    
    const ReplaceInFileWebpackPlugin = require('replace-in-file-webpack-plugin');
    mix.webpackConfig({
      plugins: [
          new ReplaceInFileWebpackPlugin([
              {
                  // rewrite font paths
                  dir: path.resolve('public/admin/plugins/global'),
                  test: /\.css$/,
                  rules: [
                      {
                        // web 
                        search: /url\(('?\.\.\/)?fonts\/(eot|woff2|woff|ttf)\/(IRANSansWeb(?:_Black|_Bold|_Medium|_Light|_UltraLight)?\..*?)'?\)/g,
                        replace: 'url(fonts/WebFonts/$3)',
                      },
                      {
                        // fontawesome
                        search: /url\((\.\.\/)?webfonts\/(fa-.*?)"?\)/g,
                        replace: 'url(fonts/@fortawesome/$2)',
                      },
                      {
                          // flaticon
                          search: /url\(("?\.\/)?font\/(Flaticon\..*?)"?\)/g,
                          replace: 'url(fonts/flaticon/$2)',
                      },
                      {
                          // flaticon2
                          search: /url\(("?\.\/)?font\/(Flaticon2\..*?)"?\)/g,
                          replace: 'url(fonts/flaticon2/$2)',
                      },
                      {
                          // keenthemes fonts
                          search: /url\(("?\.\/)?(Ki\..*?)"?\)/g,
                          replace: 'url(fonts/keenthemes-icons/$2)',
                      },
                      {
                          // lineawesome fonts
                          search: /url\(("?\.\.\/)?fonts\/(la-.*?)"?\)/g,
                          replace: 'url(fonts/line-awesome/$2)',
                      },
                      {
                          // socicons
                          search: /url\(("?\.\.\/)?font\/(socicon\..*?)"?\)/g,
                          replace: 'url(fonts/socicon/$2)',
                      },
                  ],
              },
          ]),
      ],
  });

    // Webpack.mix does not copy fonts, manually copy
    (glob.sync('resources/views/newadmin/metronic/plugins/**/*.+(woff|woff2|eot|ttf)') || []).forEach(file => {
      var folder = file.match(/resources\/views\/newadmin\/metronic\/plugins\/(.*?)\//)[1];
      mix.copy(file, `public/admin/plugins/global/fonts/${folder}/${path.basename(file)}`);
    });
    (glob.sync('node_modules/+(@fortawesome|socicon|line-awesome)/**/*.+(woff|woff2|eot|ttf)') || []).forEach(file => {
      var folder = file.match(/node_modules\/(.*?)\//)[1];
      mix.copy(file, `public/plugins/global/fonts/${folder}/${path.basename(file)}`);
    });

    mix.scripts([
      'node_modules/datatables.net/js/jquery.dataTables.js',
      'node_modules/datatables.net-bs4/js/dataTables.bootstrap4.js',
      'node_modules/datatables.net-autofill/js/dataTables.autoFill.min.js',
      'node_modules/datatables.net-autofill-bs4/js/autoFill.bootstrap4.min.js',
      'node_modules/jszip/dist/jszip.min.js',
      'node_modules/pdfmake/build/pdfmake.min.js',
      'node_modules/pdfmake/build/vfs_fonts.js',
      'node_modules/datatables.net-buttons/js/dataTables.buttons.min.js',
      'node_modules/datatables.net-buttons-bs4/js/buttons.bootstrap4.min.js',
      'node_modules/datatables.net-buttons/js/buttons.colVis.js',
      'node_modules/datatables.net-buttons/js/buttons.flash.js',
      'node_modules/datatables.net-buttons/js/buttons.html5.js',
      'node_modules/datatables.net-buttons/js/buttons.print.js',
      'node_modules/datatables.net-colreorder/js/dataTables.colReorder.min.js',
      'node_modules/datatables.net-fixedcolumns/js/dataTables.fixedColumns.min.js',
      'node_modules/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js',
      'node_modules/datatables.net-keytable/js/dataTables.keyTable.min.js',
      'node_modules/datatables.net-responsive/js/dataTables.responsive.min.js',
      'node_modules/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js',
      'node_modules/datatables.net-rowgroup/js/dataTables.rowGroup.min.js',
      'node_modules/datatables.net-rowreorder/js/dataTables.rowReorder.min.js',
      'node_modules/datatables.net-scroller/js/dataTables.scroller.min.js',
      'node_modules/datatables.net-select/js/dataTables.select.min.js',
  ], 'public/admin/plugins/custom/datatables/datatables.bundle.js');
  mix.styles([
      'node_modules/datatables.net-bs4/css/dataTables.bootstrap4.css',
      'node_modules/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css',
      'node_modules/datatables.net-autofill-bs4/css/autoFill.bootstrap4.min.css',
      'node_modules/datatables.net-colreorder-bs4/css/colReorder.bootstrap4.min.css',
      'node_modules/datatables.net-fixedcolumns-bs4/css/fixedColumns.bootstrap4.min.css',
      'node_modules/datatables.net-fixedheader-bs4/css/fixedHeader.bootstrap4.min.css',
      'node_modules/datatables.net-keytable-bs4/css/keyTable.bootstrap4.min.css',
      'node_modules/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css',
      'node_modules/datatables.net-rowgroup-bs4/css/rowGroup.bootstrap4.min.css',
      'node_modules/datatables.net-rowreorder-bs4/css/rowReorder.bootstrap4.min.css',
      'node_modules/datatables.net-scroller-bs4/css/scroller.bootstrap4.min.css',
      'node_modules/datatables.net-select-bs4/css/select.bootstrap4.min.css',
  ], 'public/admin/plugins/custom/datatables/datatables.bundle.css');

	}
    else{
    
      mix.webpackConfig({
        module: {
          rules: [
            {
              test: /\.js$/, //Regular expression 
              //exclude: /(node_modules|bower_components)/,//excluded node_modules 
              use: {
              loader: "babel-loader", 
              options: {
                presets: ["@babel/preset-env"]  //Preset used for env setup
               }
              }
             }
          ]
        },
        resolve: {
          extensions: ['*', '.js']
        },
      }).js('resources/views/index/'+ theme +'/js/app.js', 'public/js')
      .sass('resources/views/index/'+ theme +'/sass/app.scss', 'public/css').version();

    
    }