<!--begin::Login Sign in form-->
<div class="login-signin">
    <div class="mb-20">
        <h3>ورود به سامانه داشبورد</h3>
        <div class="text-muted font-weight-bold">اطلاعات خود را جهت ورود به سامانه وارد نمائید.</div>
    </div>
    <form class="form" id="kt_login_signin_form" action="<?php echo e(url('/auth/login')); ?>" class="login-form" method="POST">
        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>"  >
        <div class="form-group mb-5">
            <input class="form-control h-auto form-control-solid py-4 px-8" type="text" placeholder="<?php echo app('translator')->getFromJson('language.username'); ?>" name="username" autocomplete="off" value="<?php echo e(old('username')); ?>"/>
        </div>
        <div class="form-group mb-5">
            <input class="form-control h-auto form-control-solid py-4 px-8" type="password" placeholder="<?php echo app('translator')->getFromJson('language.password'); ?>" name="password" autocomplete="off"/>
        </div>
        <div class="form-group mb-5 d-flex justify-content-between">
            <?php echo captcha_img('management'); ?>

            <span class="input-group-btn">
                <button class="btn btn-outline-secondary" data-action="recaptcha"  type="button"  title="<?php echo app('translator')->getFromJson('language.recaptcha'); ?>">
                    <i class="flaticon2-reload"></i>
                </button>
            </span>
        </div>
        <div class="form-group mb-5">
            <input type="text" name="captcha"  class="form-control h-auto form-control-solid py-4 px-8" autocomplete="off" placeholder="<?php echo app('translator')->getFromJson('language.security code'); ?>">
        </div>
        
    
        <div class="form-group d-flex flex-wrap justify-content-between align-items-center">
            <div class="checkbox-inline">
                <label class="checkbox m-0 text-muted">
                <input type="checkbox" name="remember" value="1" <?php if(old('remember')): ?> checked="checked" <?php endif; ?>  />
                <span></span><?php echo app('translator')->getFromJson('language.remember me'); ?></label>
            </div>

            <a href="javascript:;" id="forget-password" class="text-muted text-hover-primary"><?php echo app('translator')->getFromJson('language.forgot your password ?'); ?></a>
        </div>
        <button  type="submit" id="kt_login_signin_submit" class="btn btn-primary font-weight-bold px-9 py-4 my-3 mx-4"> <?php echo app('translator')->getFromJson('language.login'); ?></button>
    </form>
    <?php if(count($errors) > 0): ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
    <?php if(Session::get('success')): ?>
        <div class="alert alert-success">
            <button class="close" data-close="alert"></button>
            <span><?php echo Session::get('success'); ?></span>
        </div>
    <?php endif; ?>
    <div class="alert alert-danger d-none">
        <button class="close" data-close="alert"></button>
        <span><?php echo app('translator')->getFromJson('language.enter any username and password.'); ?></span>
    </div>
   
</div>
<!--end::Login Sign in form-->
