<div class="modal" id="loginModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-overlay">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title mt-0" id="exampleModalLongTitle">ورود به سامانه</h5>
          <div role="button" class="close" data-dismiss="modal" aria-label="Close" data-target="loginModal">
            <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#000000">
              <path d="M0 0h24v24H0z" fill="none"></path>
              <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"></path>
            </svg>
          </div>
        </div>
        <div class="modal-body">
          <form class="modal-login-form" action="<?php echo e(url('/User/signin')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php if(Request::has('previous')): ?>
            <input type="hidden" name="previous" value="<?php echo e(Request::get('previous')); ?>">
            <?php else: ?>
            <input type="hidden" name="previous" value="<?php echo e(Request::url()); ?>">
            <?php endif; ?>
            <div class="form-group mobile-section">
              <label for="emailAddress">شماره موبایل</label>
              <input type="text" name="username" id="mobileRegisterForm" autocomplete="off" class="form-control input-lg input-ltr c-ui-input__field" placeholder="شماره موبایل خود را وارد نمائید " value="<?php echo e(old('username')); ?>">
              <div class="invalid-feedback" id="register-mobile-num-required">این شماره موبایل/ ایمیل معتبر نیست
              </div>
            </div>

            <div class="form-group password-section">
              <label for="emailAddress">رمز عبور</label>
              <input type="password" name="password" id="passwordRegisterForm" autocomplete="off" class="form-control input-lg input-ltr c-ui-input__field">
              <div class="invalid-feedback" id="register-password-help-block ">کلمه عبور باید حداقل ۶ کاراکتر باشد
              </div>
            </div>

            <div class="custom-control custom-checkbox pr-0">
              <input type="checkbox" class="custom-control-input" id="rememberID" <?php if(old('remember')): ?> checked="checked" <?php endif; ?>>
              <label class="custom-control-label" for="rememberID"><?php echo app('translator')->getFromJson('language.remember me'); ?></label>
            </div>

            <button type="submit" class="btn loginBtn mt-2 js-ajax-login">ورود</button>
            <div class="forgot-pass text-left mb-4">
              <a href="/User/forgot/" class="btn-link-spoiler">
                رمز عبور خود را فراموش کرده ام
              </a>
            </div>
          </form>

          <div class="registered-section">
            <div class="card-footer text-muted">
              کاربر جدید هستید
              <a href="/User/register?previous=<?php if(Request::has('previous')): ?><?php echo e(Request::get('previous')); ?> <?php else: ?><?php echo e(URL::previous()); ?> <?php endif; ?>" class="btn-link-spoiler">
                ثبت نام در سامانه گلدیران
              </a>
            </div>
          </div>

          <div class="alert alert-danger d-none js-login-error">
            نام کاربری یا کلمه عبور اشتباه است
          </div>
        </div>

      </div>
    </div>
  </div>
</div>