<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" <?php if(config('layout.self.rtl')): ?>  direction="rtl" dir="rtl" <?php endif; ?> <?php echo e(Metronic::printAttrs('html')); ?> <?php echo e(Metronic::printClasses('html')); ?>>
    <head>
        <meta charset="utf-8"/>
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
        
        <title><?php echo e(config('app.name')); ?> | <?php echo $__env->yieldContent('title', $page_title ?? ''); ?></title>

        
        <meta name="description" content="<?php echo $__env->yieldContent('page_description', $page_description ?? ''); ?>"/>
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>
        <link href="/public/admin/css/pages/login/classic/login-4.css" rel="stylesheet" type="text/css" />
        
        <link rel="shortcut icon" href="<?php echo e(asset('public/admin/media/logos/favicon.ico')); ?>" />

        
        <?php $__currentLoopData = config('layout.resources.css'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $style): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <link href="<?php echo e(config('layout.self.rtl') && false ? asset(Metronic::rtlCssPath($style)) : asset($style)); ?>" rel="stylesheet" type="text/css"/>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
        <?php $__currentLoopData = Metronic::initThemes(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $theme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <link href="<?php echo e(config('layout.self.rtl') && false ? asset(Metronic::rtlCssPath($theme)) : asset($theme)); ?>" rel="stylesheet" type="text/css"/>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
    </head>

    <body id="kt_body" class="header-fixed header-mobile-fixed subheader-enabled subheader-fixed aside-enabled aside-fixed aside-minimize-hoverable page-loading">

        <div class="d-flex flex-column flex-root">
			<!--begin::Login-->
			<div class="login login-4 login-signin-on d-flex flex-row-fluid" id="kt_login">
				<div class="d-flex flex-center flex-row-fluid bgi-size-cover bgi-position-top bgi-no-repeat" style="background-image: url('/metronic/theme/html/demo1/dist/assets/media/bg/bg-3.jpg');">
					<div class="login-form text-center p-7 position-relative overflow-hidden">
						<!--begin::Login Header-->
						<div class="d-flex flex-center mb-15">
							<a href="#">
								<img src="/admin/media/logos/logo-letter-13.png" class="max-h-75px" alt="" />
							</a>
						</div>
						<!--end::Login Header-->
						<?php echo $__env->make('account::admin.auth.loginForm', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        <?php echo $__env->make('account::admin.auth.forgetForm', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
					</div>
				</div>
			</div>
			<!--end::Login-->
		</div>

        
        <script>
            var KTAppSettings = <?php echo json_encode(config('layout.js'), JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES); ?>;
        </script>
<script>
    var section = "<?php echo e(config('app.section')); ?>", 
    controller = "<?php echo e(config('app.controller')); ?>", 
    action = "<?php echo e(config('app.action')); ?>",  
    locale = "<?php echo e(config('app.localization')); ?>",
    lang = "<?php echo e(App::getLocale()); ?>", 
    environment = '<?php echo e(App::environment()); ?>', 
    random = "<?php echo e(config('app.random')); ?>";
    window.dir =  "<?php echo e(config('app.dir', 'ltr')); ?>";
</script>
        
        <?php $__currentLoopData = config('layout.resources.js'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $script): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <script src="<?php echo e(asset($script)); ?>" type="text/javascript"></script>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
        
        <?php echo $__env->yieldContent('scripts'); ?>
        
        
        <script>
            jQuery(document).ready(function () {
                
                // Login.init();
            });
        </script>
    </body>
</html>
