<!-- BEGIN PAGE HEADER-->
<div class="row">
    <div class="col-md-12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            <?php if(@$title && preg_match('/^language\./', $title)): ?> 
                 <?php echo app('translator')->getFromJson($title); ?>
            <?php elseif(@$title): ?>
                <?php echo t("$title") ?>
            <?php else: ?> 
                &nbsp; 
            <?php endif; ?>
        </h3>
        <ul class="page-breadcrumb breadcrumb">

            <?php if(@$actionlist): ?>
                <li class="btn-group">
                    <button type="button" class="btn blue dropdown-toggle" data-toggle="dropdown" data-hover="dropdown" data-delay="1000" data-close-others="true">
                    <span> <?php echo app('translator')->getFromJson('language.actions'); ?> </span>
                    <i class="fa fa-angle-down"></i>
                    </button>
                    <ul class="dropdown-menu pull-right" role="menu">
                        <?php $__currentLoopData = @$actionlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e($action.link); ?>"><?php echo e($action.name); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </li>
            <?php endif; ?>

            <li>
                <i class="fa fa-home"></i>
                <?php if(@$title and strtolower(config('app.controller')) != 'home'): ?>
                    <a href="<?php echo e(Lib::getCurrentURL('section') . '/Home'); ?>"><?php echo app('translator')->getFromJson('language.home'); ?></a>
                    <i class="fa <?php if(config('app.dir') == 'rtl'): ?> fa-angle-left <?php else: ?> fa-angle-right <?php endif; ?>"></i>
                <?php else: ?>
                    <i class="fa <?php if(config('app.dir') == 'rtl'): ?> fa-angle-left <?php else: ?> fa-angle-right <?php endif; ?>"></i>
                <?php endif; ?>    
            </li>
            <?php if(@$title and @$title2): ?>
                <li>
                    <?php if(@$link): ?>
                        <a href="<?php echo e($link); ?>">
                            <?php echo app('translator')->getFromJson(preg_match('/^language\./', $title) ? $title:  env('APP_LANG_PREFIX') . '.' . @$title); ?>
                        </a>
                    <?php else: ?>
                        <span>
                            <?php echo app('translator')->getFromJson(preg_match('/^language\./', $title) ? $title:  env('APP_LANG_PREFIX') . '.' . @$title); ?>
                        </span>
                    <?php endif; ?>

                    <i class="fa <?php if(config('app.dir') == 'rtl'): ?> fa-angle-left <?php else: ?> fa-angle-right <?php endif; ?>"></i>
                    <?php if(@$link2): ?>
                        <a href="<?php echo e($link2); ?>"><?php echo e(@$title2); ?></a>
                    <?php else: ?>
                        <span><?php echo e(@$title2); ?></span>
                    <?php endif; ?>
                </li>
            <?php elseif(@$title and config('app.controller') != 'home'): ?>
                <li>
                    <span>
                        <?php echo app('translator')->getFromJson(preg_match('/^language\./', $title) ? $title:  env('APP_LANG_PREFIX') . '.' . @$title); ?>
                    </span>
                </li>
            <?php endif; ?>

            <li class="pull-right">
                <div id="dashboard-report-range" class="dashboard-date-range tooltips"  style="display: block;background: #bfcad1; cursor: default;">
                    <i class="fa fa-calendar"></i>
                    <span><?php echo e(trans('language.today') . ' ' . (config('app.dir') == 'ltr' ? date('l d F Y - H:i:s') : (convertDigit(FarsiLib::jDate('l d F ماه Y - ') . date('H:i:s'))))); ?></span>
                    
                </div>
            </li>
        </ul>
        <!-- END PAGE TITLE & BREADCRUMB-->
    </div>
</div>
<!-- END PAGE HEADER-->