<?php $__env->startSection('content'); ?>
    <div class="blog-body">
        <div class="blog-banner-holder">
            <img src="/source/material/contactbg.png">
            <div class="container">
                <div class="row align-items-center hero-wrap justify-content-between mt-5 mb-5">
                    <div class="col-12 col-md-6 ">
                        <div class="wrapper">
                            <div class=" m-auto">
                                <h1><?php echo t("site name") ?></h1>
                                <p class="text-justify">
                                    <?php echo t("site description") ?>
                                </p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <div class="wrapper">
        <div class="main">
            <div class="contact-content">
                <div class="container">
                    <div class="row justify-content-between ">
                        <div class="col-12 col-md-6  mt-3">
                            <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <h2><span class="eqlid_title"><?php echo e($contact->xcontact_title); ?></span></h2>
                                <div>
                                    <?php echo $contact->xcontact_desc; ?>

                                </div>

                                <h3 class="mt-5"><span class="eqlid_title">
                                    <?php echo t("path to us") ?>
                                    </span>
                                </h3>
                                <div class="row contact-items">
                                    <?php $__currentLoopData = $contact->info()->orderBy('xrank', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php switch($item->xcontactinfo_type):
                                            case ('Tel'): ?>
                                                <div class="col-12">
                                                    <div class="contact-info-item d-flex align-items-center">
                                                        <i class="icon-call"></i>
                                                        <a
                                                            href="tel:<?php echo e($item->xcontactinfo_desc); ?>"><?php echo e(FarsiLib::convertDigit($item->xcontactinfo_desc)); ?></a>
                                                    </div>
                                                </div>
                                            <?php break; ?>
                                            <?php case ('Phone'): ?>
                                                <div class="col-12">
                                                    <div class="contact-info-item d-flex align-items-center">
                                                        <i class="icon-sms"></i>
                                                        <a
                                                            href="tel:<?php echo e($item->xcontactinfo_desc); ?>"><?php echo e(FarsiLib::convertDigit($item->xcontactinfo_desc)); ?></a>
                                                    </div>
                                                </div>
                                            <?php break; ?>
                                            <?php case ('Fax'): ?>
                                                <div class="col-12">
                                                    <div class="contact-info-item d-flex align-items-center">
                                                        <i class="icon-fax"></i>
                                                        <a
                                                            href="tel:<?php echo e($item->xcontactinfo_desc); ?>"><?php echo e(FarsiLib::convertDigit($item->xcontactinfo_desc)); ?></a>
                                                    </div>
                                                </div>

                                            <?php break; ?>
                                            <?php case ('Mail'): ?>
                                                <div class="col-12">
                                                    <div class="contact-info-item d-flex align-items-center">
                                                        <i class="icon-mail"></i>
                                                        <a
                                                            href="mailto:<?php echo e($item->xcontactinfo_desc); ?>"><?php echo e(FarsiLib::convertDigit($item->xcontactinfo_desc)); ?></a>
                                                    </div>
                                                </div>

                                            <?php break; ?>
                                            <?php case ('Address'): ?>
                                                <div class="col-12">
                                                    <div class="contact-info-item d-flex align-items-center">
                                                        <i class="icon-locate"></i>
                                                        <a><?php echo e($item->xcontactinfo_desc); ?></a>
                                                    </div>
                                                </div>

                                            <?php break; ?>
                                            <?php default: ?>

                                        <?php endswitch; ?>


                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <h3 class="mt-5"><span class="eqlid_title">
                               <?php echo t("in socials") ?>
                                </span></h3>
                            <div class="social-offer">
                                <?php if(@$social): ?>
                                    <?php $__currentLoopData = $social; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a class="social-icon social-icon-sm social-icon-transparent social-<?php echo e($item->xsocial_title); ?>"
                                            href="<?php echo e($item->xsocial_link); ?>" title="<?php echo e($item->xsocial_title); ?> address">
                                            <i class="icon-<?php echo e($item->xsocial_title); ?>"></i>
                                            <i class="icon-<?php echo e($item->xsocial_title); ?>"></i>
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>

                        </div>

                        <div class="col-12 col-md-5  mt-3">
                            <h2 class="title"><span class="eqlid_title">
                                <?php echo t("call in us") ?>
                                </span></h2>
                            <p class="description mb-3">
                                <?php echo t("start conversation") ?>
                            </p>
                            <form role="form" id="contact-form" method="post" action="/Contact/sendForm">
                                <?php if(count($errors) > 0): ?>
                                    <div class="alert alert-danger">
                                        <ul>
                                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($error); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                <?php endif; ?>
                                <?php if(Session::get('success')): ?>
                                    <div class="alert alert-success">
                                        <button class="close" data-close="alert"></button>
                                        <span><?php echo Session::get('success'); ?></span>
                                    </div>
                                <?php endif; ?>
                                <input type="hidden" class="field" name="_token" value="<?php echo e(csrf_token()); ?>">

                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="icon-login"></i></span>
                                    </div>
                                    <input type="text" name="name" class="form-control" value="<?php echo e(old('name')); ?>"
                                        placeholder="<?php echo t("name") ?>" aria-label="Your Name...">
                                </div>
                                <label></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="icon-email"></i></span>
                                    </div>
                                    <input type="email" class="form-control" name="email" value="<?php echo e(old('email')); ?>"
                                        placeholder="<?php echo t("email") ?>" aria-label="Email Here...">
                                </div>
                                <label></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="icon-tell"></i></span>
                                    </div>
                                    <input type="text" class="form-control" name="mobile" value="<?php echo e(old('mobile')); ?>"
                                        placeholder="<?php echo t("mobile") ?>" aria-label="mobile Here...">
                                </div>
                                <label></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="icon-file"></i></span>
                                    </div>

                                    <select name="subject" class="form-control">
                                    <option value="0"><?php echo t("select") ?>...</option>
                                    <option value="1"><?php echo t("tracking request") ?></option>
                                    <option value="2"><?php echo t("calim") ?></option>
                                    <option value="3"><?php echo t("other") ?></option>
                                </select>
                                </div>
                                <div class="form-group">
                                    <label></label>
                                    <textarea name="msg" placeholder="<?php echo t("message") ?>" class="form-control" id="message"
                                        rows="6"></textarea>
                                </div>
                                <div class="comment-action row mb-5">
                                    <div class="col-12">
                                        <?php echo captcha_img('flat'); ?>

                                        
                                        <input name="captcha" maxlength="8" type="text" value="<?php echo e(old('captcha')); ?>"
                                            placeholder="<?php echo t("Secure Code") ?>" required>
                                        <input type="submit" class="btn" value="<?php echo t("send") ?>">
                                    </div>
                                </div>



                            </form>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-12">
                            <?php echo $contacts[0]->xcontact_map; ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

<?php $__env->stopSection(); ?>
