<?php $__env->startSection('content'); ?>
<div class="blog-body">
    <div class="blog-banner-holder">
        <img src="/source/material/jobbg.png">
        <div class="container">
            <div class="row align-items-center hero-wrap justify-content-between mt-5 mb-5">
                <div class="col-12 col-md-6 ">
                    <div class="wrapper">
                        <div class=" m-auto">
                            <h1> <?php echo t("site name") ?></h1>
                            <p class="text-justify">
                               <?php echo t("job detail description") ?>
                            </p>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<div class="job-detail">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-8">
                <div class="job-detail-content">
                    <h1><?php echo e($job->name); ?></h1>
                    <hr>
                    <?php echo $job->description; ?>

                </div>
            </div>
            <div class="col-12 col-md-4">
                <?php if(session('status')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('status')); ?>

                    </div>
                <?php else: ?>
                <div class="job-register">
                    <h2><?php echo t("submit your resume") ?></h2>
                    <hr>
                    <form action="/jobs/sendResume" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" value="<?php echo e($job->id); ?>">
                        <input type="text" name="name" value="" placeholder="<?php echo t("name") ?>  ">
                        <input type="text" name="mobile" value="" placeholder="<?php echo t("mobile") ?> ">
                        <input type="text" name="email" value="" placeholder="<?php echo t("email") ?> ">
                        
                        <div class="custom-file mb-2">
                            <input name="resumeFile" type="file" class="custom-file-input" id="customFile">
                            <label class="custom-upload-label" for="customFile" id="resume-file-label"><?php echo t("upload resume file") ?></label>
                        </div>
                        <div class="d-flex">
                                <?php echo captcha_img('flat'); ?>

                                <input name="captcha" maxlength="8" maxlength="5" type="text" value="<?php echo e(old('captcha')); ?>" placeholder="<?php echo t("secure code") ?>" required />
                        </div>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <input type="submit" value=" <?php echo t("send") ?>" class="btn btn-danger">
                    </form>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>