<meta charset="utf-8"/>
<title>
    <?php echo e(@$title ? (preg_match('/^language\./', $title) ? trans($title):  $title):  ''); ?>

    <?php echo e(@$title2 ? ' | ' . str_limit($title2, $limit = 57, $end = ''):  ''); ?>

</title>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<meta content="<?php echo e($description ?? @$config['seo']['description']); ?>" name="description"/>

<?php if(@$canonical): ?>
    <link rel="canonical" href="<?php echo e(rtrim($canonical,'/')); ?>"/>
<?php else: ?>
    <link rel="canonical" href="<?php echo e(rtrim(Str::finish(config('app.url'),'/') . Request::path(),'/')); ?>"/>    
<?php endif; ?>
<?php if(@$seoNoIndex): ?><meta name="robots" content="noindex, nofollow"><?php endif; ?>
<meta content="" name="author"/>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
<meta name="enamad" content="983427"/>

<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link href="/public/eqlid/logo.ico" rel="shortcut icon" />
<link rel="icon" type="image/png" href="/eqlid/logo.png" sizes="32x32" />
<link rel="icon" type="image/png" href="/eqlid/logo.png" sizes="16x16" />

    <meta property="og:type" content="website">
    <meta property="og:title" content="<?php echo e(@$title); ?>">
    <meta property="og:url" content="<?php echo e(url()->full()); ?>">
    <meta property="og:image" content="https://eqlidsugar.com/eqlid/logo.png">
    <meta property="og:image:secure_url" content="https://eqlidsugar.com/eqlid/logo.png" />
    <meta property="og:image:width" content="135">
    <meta property="og:image:height" content="200">

<!-- Favicons -->
<link rel="shortcut icon" href="">
<link rel="apple-touch-icon" href="" sizes="57x57">
<link rel="apple-touch-icon" href="" sizes="72x72">
<link rel="apple-touch-icon" href="" sizes="114x114">
<link rel="apple-touch-icon" href="" sizes="144x144">

<?php if(in_array(strtolower(config('app.controller')),['shop','product','cart','shipping','payment','gbox'])): ?>
    <link href="/css/assets/vendor.css" rel="stylesheet">
<?php else: ?>
   <link href="/css/app.css" rel="stylesheet"> 
<?php endif; ?>

<?php if(in_array(strtolower(config('app.controller')),['cart','shipping','payment'])): ?>
    <link href="/css/assets/cart.css" rel="stylesheet">
<?php endif; ?>

<?php ${'dir'} =  config('app.dir', 'ltr'); ?>

<noscript>
    <link rel="stylesheet" href="<?php echo e(asset('/assets/plugins/jquery-file-upload/css/jquery.fileupload-noscript.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/plugins/jquery-file-upload/css/jquery.fileupload-ui-noscript.css')); ?>">
</noscript>


<script>
    var section = "<?php echo e(config('app.section')); ?>",
    	controller = "<?php echo e(config('app.controller')); ?>",
    	action = "<?php echo e(config('app.action')); ?>",
    	locale = "<?php echo e(config('app.localization')); ?>",
    	lang = "<?php echo e(App::getLocale()); ?>",
    	environment = '<?php echo e(App::environment()); ?>',
    	random = "<?php echo e(config('app.random')); ?>";

    window.dir =  "<?php echo e(config('app.dir')); ?>";
</script>


<?php if(@$schemaBreadCrump): ?>
<script type="application/ld+json">
    <?php echo $schemaBreadCrump; ?>

</script>
<?php endif; ?>
<?php if(@$schemaWebsite): ?>
<script type="application/ld+json">
    <?php echo $schemaWebsite; ?>

</script>
<?php endif; ?>
<?php if(@$schemaArticle): ?>
<script type="application/ld+json">
    <?php echo $schemaArticle; ?>

</script>
<?php endif; ?>
<?php if(@$schemaProduct): ?>
<script type="application/ld+json">
    <?php echo $schemaProduct; ?>

</script>
<?php endif; ?>