<div class="portlet-title">
    <div class="caption">
        <i class="fa fa-<?php echo e(@$toolbarIcon ? @$toolbarIcon:  'globe'); ?>"></i>
        <?php if(@$customToolbarTitle): ?>
            <?php echo e(@$customToolbarTitle); ?>

        <?php else: ?>
            <?php if(config('app.dir') == 'rtl'): ?>
                <?php echo app('translator')->getFromJson('language.list of'); ?>
            <?php endif; ?>
            <?php if(@$title2): ?>
                <?php echo e($title2); ?>

            <?php elseif(@$title): ?>
                <?php echo app('translator')->getFromJson(preg_match('/^language\./', $title) ? $title:  (env('APP_LANG_PREFIX') . '.' . $title)); ?>
            <?php else: ?>
                &nbsp;
            <?php endif; ?>
            <?php if(config('app.dir') == 'ltr'): ?>
                <?php echo app('translator')->getFromJson('language.list'); ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
    <div class="tools">
        
        
        

        <?php if(@$toolbar['showTools']): ?>
            <div class="btn-group">
                <a href="javascript:;" class="dropdown-toggle" data-toggle="dropdown" title="<?php echo app('translator')->getFromJson('language.tools'); ?>">
                    <i class="fa fa-briefcase"></i>
                </a>
                <ul class="dropdown-menu <?php if(config('app.dir') == 'rtl'): ?> pull-left <?php else: ?> pull-right <?php endif; ?>">
                    <li>
                        <a href="#"> <?php echo app('translator')->getFromJson('language.print'); ?></a>
                    </li>
                    <li>
                        <a href="#" onclick="App.pdfClick();"> <?php echo app('translator')->getFromJson('language.save as pdf'); ?></a>
                    </li>
                    <li>
                        <a href="#"  onclick="App.excelClick();">  <?php echo app('translator')->getFromJson('language.export to excel'); ?> </a>
                    </li>
                    <?php if(@$toolbar['showAddressPdf']): ?>
                    <li>
                        <a href="#"  onclick="App.pdfAddressClick();">  <?php echo app('translator')->getFromJson('language.save address as pdf'); ?> </a>
                    </li>
                    <?php endif; ?>
                    <?php if(@$toolbar['showAllExportExcel']): ?>
                    <li>
                        <a href="#"  onclick="App.excelAllClick();">  <?php echo app('translator')->getFromJson('language.export to excel'); ?> </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        <?php endif; ?>

        <?php if(!@$toolbar['showImport']): ?>
            <a href="<?php echo e(Lib::getCurrentURL('controller') . '/import/'); ?>" class="tooltips create-icon" data-toggle=""
                    title="<?php echo app('translator')->getFromJson('language.import'); ?>"
                        onclick="App.call(this, {'method': 'import', 'args': {'type': '<?php echo e(@$type); ?>'}}, event);">
                 &nbsp;<i class="fa fa-plus"></i>
            </a>
        <?php endif; ?>

        <?php if(!@$toolbar['hideLimit']): ?>
            
            <input name="q[limit][count]" class="knob per-page display-none" data-angleoffset="-90" data-anglearc="180" data-fgcolor="#66EE66" value="<?php echo e(config('custom.perPage', 10)); ?>" data-height="17" data-width="45" data-displayInput="falss" data-options="{'min': 10, 'max': 200, 'step': 5, 'inputColor': '#fff'}" style="top: -1px;" data-release="App.list();" >
        <?php endif; ?>

        <a href="javascript:;" class="tooltips reload-icon reload" data-url="/<?php echo e(Request::path()); ?>" style="background: none;"
            title="<?php echo app('translator')->getFromJson('language.reload list'); ?>">
            <i class="fas fa-sync-alt"></i>
        </a>

        <?php if(@$tplsearch and !@$toolbar['hideSearch']): ?>
            <a href="javascript:;" class="tooltips search-icon" title="<?php echo app('translator')->getFromJson('language.search'); ?>">
                <i class="fa fa-search"></i>
            </a>
        <?php endif; ?>

        <?php if(!@$toolbar['hideCreate']): ?>
            <?php ${'id'} =  config('app.id'); ?>
            <a href="<?php echo e(Lib::getCurrentURL('controller') . '/create/' . $id); ?>" class="tooltips create-icon" data-toggle=""
                    title="<?php echo app('translator')->getFromJson('language.add new'); ?>"
                        onclick="App.call(this, {'method': 'create', 'id': '<?php echo e(config('app.id')); ?>', 'args': {'type': '<?php echo e(@$type); ?>'}}, event);">
                 &nbsp;<i class="fa fa-plus"></i>
            </a>
        <?php endif; ?>

    </div>
</div>
