<meta charset="utf-8"/>
<title>
    <?php echo e(config('app.section') ? trans('language.' . config('app.section')) . ' | ':  ''); ?> 
    <?php echo e(@$title ? (preg_match('/^language\./', $title) ? trans($title):  trans(config('custom.site.lang', 'language') . '.' . $title)):  ''); ?>  
    <?php echo e(@$title2 ? ' | ' . $title2:  ''); ?>

</title>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<meta content="" name="description"/>
<meta content="" name="author"/>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />

<?php ${'dir'} =  config('app.dir', 'ltr'); ?>
<?php Assets::add('fontface'); ?>

<?php if($dir == 'rtl'): ?> 
    <?php Assets::add('core-css-rtl'); ?>
<?php else: ?>   
    <?php Assets::add('core-css'); ?>
<?php endif; ?>

<?php Assets::add('theme-css' . ($dir == 'rtl' ? ('-' . $dir):  '')); ?>

<?php Assets::add('plugins-admin-css'); ?>  
<?php if($dir == 'rtl'): ?> 
    <?php Assets::add('plugins-admin-rtl-css'); ?> 
<?php endif; ?>

<?php Assets::add('plugin-css' . ($dir == 'rtl' ? ('-' . $dir):  ''))->config(array('pipeline' => compareAssets(Assets::getCss()))); ?>

<?php if($dir == 'rtl'): ?> 
    <?php Assets::add('core-js'); ?>
    <?php Assets::add('core-js-rtl')->config(array('pipeline' => compareAssets(Assets::getJs()))); ?>
<?php else: ?>  
    <?php Assets::add('core-js')->config(array('pipeline' => compareAssets(Assets::getJs()))); ?>
<?php endif; ?>


<link href="<?php echo e(asset('/assets/plugins/metronic/css/themes/' . config('app.theme', 'default') . '.css')); ?>" rel="stylesheet" type="text/css" id="style_color"/>
<?php echo Assets::css(); ?>

<?php echo Assets::js(); ?>


<noscript>
    <link rel="stylesheet" href="<?php echo e(asset('/assets/plugins/jquery-file-upload/css/jquery.fileupload-noscript.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/plugins/jquery-file-upload/css/jquery.fileupload-ui-noscript.css')); ?>">
</noscript>

<script src="<?php echo e(asset('/assets/cache/' . jsLanguage())); ?>"></script>  
<script>
    var section = "<?php echo e(config('app.section')); ?>", controller = "<?php echo e(config('app.controller')); ?>", action = "<?php echo e(config('app.action')); ?>",  locale = "<?php echo e(config('app.localization')); ?>";
    var lang = "<?php echo e(App::getLocale()); ?>", environment = '<?php echo e(App::environment()); ?>', random = "<?php echo e(config('app.random')); ?>";
    window.dir =  "<?php echo e(config('app.dir', 'ltr')); ?>";
    
    jQuery(document).ready(function() {
        App.init(); // initlayout and core plugins        
        UIExtendedModals.init();

        <?php if(!Request::ajax() and @$viewEdit): ?> 
            $('.edit-responsive .modal-header .close').click(function(event) {
                window.location.href = "<?php echo e(getCurrentURL('controller')); ?>";
            });
            $('.edit-responsive form').submit(function(event) {
                window.location.href = "<?php echo e(getCurrentURL('controller')); ?>";
            });
        <?php endif; ?>    
    });
</script>