<?php
Route::prefix('public')->group(function(){
    return redirect('home/dashboard');
});
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

// Authentication Routes...
$this->get('auth/login', '\Modules\Account\Http\Controllers\Auth\LoginController@showLoginForm')->name('login');
$this->post('auth/login', '\Modules\Account\Http\Controllers\Auth\LoginController@login');
$this->any('auth/logout', '\Modules\Account\Http\Controllers\Auth\LoginController@logout')->name('logout');
$this->any('auth/fetchUser', '\Modules\Account\Http\Controllers\Auth\LoginController@fetchUser');

// Password Reset Routes...
$this->get('password/reset', '\Modules\Account\Http\Controllers\Auth\ForgotPasswordController@showLinkRequestForm')->name('password.request');
$this->post('password/email', '\Modules\Account\Http\Controllers\Auth\ForgotPasswordController@sendResetLinkEmail')->name('password.email');
$this->get('password/reset/{token}', '\Modules\Account\Http\Controllers\Auth\ResetPasswordController@showResetForm')->name('password.reset');
$this->post('password/reset', '\Modules\Account\Http\Controllers\Auth\ResetPasswordController@reset')->name('password.update');

//## captcha
Route::get('captcha/{config?}', '\Mews\Captcha\CaptchaController@getCaptcha');
Route::get('ajax_regen_captcha', function(){
    return response()->json(captcha_src('flat')); 
});
Route::get('apiCaptcha', function(){
    return app('captcha')->create('management',true);
});

if(env('APP_DEBUG', false)){
    //## debugbar
    Route::get('open', [
        'uses' => 'OpenHandlerController@handle',
        'as' => 'debugbar.openhandler',
    ]);
    Route::get('assets/stylesheets', [
        'uses' => 'AssetController@css',
        'as' => 'debugbar.assets.css',
    ]);

    Route::get('assets/javascript', [
        'uses' => 'AssetController@js',
        'as' => 'debugbar.assets.js',
    ]);
}

$locale = Request::segment(1);

if (in_array($locale, Config::get('app.locales'))) {
    App::setLocale($locale);
    Config::set('app.localization', $locale);
} else if (Request::get('lang') && in_array(Request::get('lang'), Config::get('app.locales'))) {
    App::setLocale(Request::get('lang'));
    $locale = null;
} else {
    $locale = null;
}

$dir = (App::getLocale() == 'fa' || App::getLocale() == 'ar') ? 'rtl' : 'ltr';
Config::set('app.dir', $dir);

// Route::get('/' . ($locale ? "$locale/" : ''), function () {
//     dd('sd');
//     return Lib::callAction('Index', 'Home');
// });

Route::get(($locale ? "/$locale/" : '') . 'login', function () {
    return Lib::callAction('', 'Auth');
});

Route::prefix($locale)->group(function () {
    
    Route::prefix('Admin')
        ->middleware(['auth', 'normalize', 'permission'])
        ->group(function () {
            Route::get('/', function () {
                return Lib::callAction('Admin', 'Home');
            });
            
            Route::any('/pic/{folder?}/{filename?}/{output?}', function ($folder, $filename, $output) {
                $args = $folder . '/' . $filename . '/' . $output;
                return Lib::callAction('Admin', 'pic', 'index', $args);
            });

            Route::any('/download/{folder?}/{filename?}/{cid?}/{output?}', function ($folder, $filename, $cid, $output) {
                $args = "{$folder}/{$filename}/{$cid}/{$output}";
                return Lib::callAction('Admin', 'pic', 'download', $args);
            });

            Route::any('{controller?}/{action?}/{args?}', function ($controller, $action = 'index', $args = '') {
                if ($action == 'store') {
                    //Logger::log($controller, $action, 1, $args ?? null, json_encode(Request::all()));
                }
                return Lib::callAction('Admin', $controller, $action, $args);
            })->where(array(
                'controller' => '[^/]+',
                'action' => '[^/]+',
                'args' => '[^?$]+',
            ));
        });

    Route::any('/pic/{folder?}/{filename?}/{output?}', function ($folder, $filename, $output = null) {
        $args = $folder . '/' . $filename . '/' . $output;
        return Lib::callAction('', 'pic', 'index', $args);
    })->name('pic');

    Route::any('/video/{folder?}/{filename?}/{output?}', function ($folder, $filename, $output = null) {
        $args = $folder . '/' . $filename . '/' . $output;
        return Lib::callAction('', 'video', 'index', $args);
    })->name('video');

    Route::any('/download/{folder?}/{filename?}/{cid?}/{output?}', function ($folder, $filename, $cid, $output) {
        $args = "{$folder}/{$filename}/{$cid}/{$output}";
        return Lib::callAction('', 'pic', 'download', $args);
    });
    
    Route::any('{controller?}/{action?}/{args?}', function ($controller, $action = 'index', $args = '') {
        \Storage::append('mylog.txt', $controller . ',' . $action . ',' . $args);
        return Lib::callAction('Index', $controller, $action, $args);
    })->where(array(
        'controller' => '[^/]+',
        'action' => '[^/]+',
        'args' => '[^?$]+',
    ));

});

Route::get('/home', 'HomeController@index')->name('home');
