<?php

use App\Http\Middleware\CaseInsensitiveUriValidator;
use Illuminate\Http\Request;
use Illuminate\Routing\Matching\UriValidator;
use Illuminate\Routing\Route as IlluminateRoute;

$validators = IlluminateRoute::getValidators();
$validators[] = new CaseInsensitiveUriValidator;
IlluminateRoute::$validators = array_filter($validators, function ($validator) {
    return get_class($validator) != UriValidator::class;
});
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
 */

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::namespace ('Modules\Account\Http\Controllers\Api')->group(function () {
    Route::any('GetBaseUrl.php/{id?}', 'UserController@getBaseUrl')->where('id', '[0-9]+');
    Route::post('Register/signUp', 'RegisterController@SignUp');
    Route::post('Register/signIn', 'RegisterController@SignIn');
    Route::post('Register/getSession', 'RegisterController@GetSession');
    Route::post('Register/setInfo', 'RegisterController@SetInfo');
    Route::post('Register/getInfo', 'RegisterController@GetInfo');

    Route::get('Register/forgotPassword', 'RegisterController@ForgotPassword');
    Route::get('Register/getUserId', 'RegisterController@GetUserId');

    Route::get('book_meta_info.php', 'UserController@bookInfo');
    Route::get('BookListFiles/bookfile_1.zip', 'UserController@bookZipFile');
    Route::any('pic/{folder?}/{size?}/{number?}/{id?}', function ($folder, $size, $number, $id) {
        preg_match('/(\d+)\.(jpg|gif|png|jpeg)/i', $id, $clearId);
        $args = $folder . '/' . $clearId[1] . $size . '/' . $id;
        return Lib::callAction('', 'pic', 'index', $args);

        // return redirect()->route('pic', [
        //     "folder" => $folder,
        //     "filename" => $clearId[1] . $size,
        //     "output" => $id,
        // ]);
    })->where('number', '[0-9]+');

    Route::any('buyprint', 'UserController@buyPrint');
    Route::any('buyDigitalBook', 'UserController@buyDigitalBook');
    Route::any('getDigitalBook', 'UserController@getDigitalBook');
    Route::any('downloadBook', 'UserController@downloadBook');
    Route::any('buyhistory', 'UserController@buyHistory');
    Route::any('bookAdvertise', 'UserController@bookAdvertise');

});