@if($widget->general->themes == 'alone')
    @foreach($params as $item)
    <style>
        .homeIntro{
            background-image: url('/pic/page.widgets/{{ $item->mobileImage->uuid }}.jpg?x-oss-process=image/resize,m_lfit,h_800,w_600/quality,q_90')
        }
        @media screen and (min-width: 600px) {
            .homeIntro{
                background-image: url('/pic/page.widgets/{{ $item->image->uuid }}.jpg?x-oss-process=image/resize,m_lfit,h_852,w_1920/quality,q_90')
            }
        }
    </style>
        <div class="homeIntro">
            @if(@$item->description)<div class="mobile-whiter"></div> @endif
            <div class="container-fluid">
                <div class="row align-items-start hero-wrap ind-page">
                    <div class="col-12 col-md-7 pl-0 pr-0 heroTxt">
                        <div class="wrapper">
                            <div class="hero-txt-area">
                                <h1 class="{{@$item->titleColor}}">
                                    {!! $item->title !!}
                                </h1>
                                <p class="{{@$item->descriptionColor}}">
                                    {{ $item->description }}
                                </p>
                                @if($item->button->link)
                                <div class="row d-inline-flex align-items-center mt-3">
                                    <div class="col">
                                        <a href="{{ $item->button->link }}"
                                            class="btn btn-danger my-sm-0 bg-red">{{ $item->button->title }}</a>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endforeach

@elseif($widget->general->themes == 'roya')

<div class="roya-banner mt-2">
    <div class="@if($widget->general->container) container @endif">
    <section class="home-slider p-0" style="max-width: {{@$widget->general->width ? $widget->general->width . 'px' : '100%'}};margin: 10px auto 0;">
        <div class="swiper-container banner-carousel" @if(App::getLocale() != 'en') dir="rtl" @endif>
            @if (@$params)
            <div class="swiper-wrapper">
                @foreach($params as $item)
                <div class="item swiper-slide">
                    <a class="banner banner-wrapper" href="{{ $item->button->link }}">
                        <picture>
                            <source srcset="/pic/page.widgets/{{ $item->mobileImage->uuid }}.jpg?x-oss-process=image/resize,m_lfit/quality,q_90" media="(max-width: 992px)">
                            <source srcset="/pic/page.widgets/{{ $item->image->uuid }}.jpg?x-oss-process=image/resize,m_lfit/quality,q_90">
                            <img src="/pic/page.widgets/{{ $item->image->uuid }}.jpg?x-oss-process=image/resize,m_lfit/quality,q_90" alt="{{$item->title}}" style="border-radius: 10px;">
                        </picture>
                    </a>
                </div>
                @endforeach
            </div>
            <div class="swiper-pagination"></div>
            <div class="swiper-button-prev">
                <i class="icon-arrow-right"></i>
            </div>
            <div class="swiper-button-next">
                <i class="icon-arrow-left"></i>
            </div>
            @endif
    
        </div>
    </section>
    </div>
    </div>
    
@else
    <div class="sadaf-banner banner-container">
        <section class="home-slider p-0">
            <div class="swiper-container banner-carousel" @if(App::getLocale() !='en' ) dir="rtl" @endif>
                <div class="swiper-wrapper">
                    @foreach($params as $item)
                        <div class="item swiper-slide">
                            <div class="banner banner-wrapper"
                                style="background-image: url('/pic/page.widgets/{{ $item->image->uuid }}.jpg?x-oss-process=image/resize,m_lfit,h_360,w_850/quality,q_90');">
                                <div class="overlay dark-5"></div>
                                <div class="banner-content fadebox d-flex align-items-center">
                                    <div class="container">
                                        <h2 class="banner-header fadeInUp animated">
                                            {{ $item->title }}
                                        </h2>
                                        <p class="fadeInUp animated text-center mt-3">
                                            {{ $item->description }}
                                        </p>
                                        @if($item->button)
                                            <a class="btn btn-primary fadeInUp animated"
                                                href="{{ $item->button->link }}"
                                                title="{{ $item->button->title }}">{{ $item->button->title }}</a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="swiper-pagination"></div>
                <div class="swiper-button-prev"></div>
                <div class="swiper-button-next"></div>
            </div>
        </section>
    </div>

@endif
