document.addEventListener("DOMContentLoaded", function (event) {
    function setCurrentSlide(ele, index) {
        let ss = document.querySelectorAll(".swiper1 .swiper-slide");
        for (let index = 0; index < ss.length; index++) {
            ss[index].classList.remove("selected");
        }
        ele.classList.add("selected");
    }

    var swiper1 = new Swiper('.swiper1', {
        slidesPerView: 3,
        paginationClickable: true,
        spaceBetween: 30,
        freeMode: true,
        loop: false,
        
    });

    for (let index = 0; index < swiper1.slides.length; index++) {
      var ele = swiper1.slides[index];
 
      ele.addEventListener("click", function (event) {
          setCurrentSlide(event.currentTarget, index);
          swiper1.slideTo(index, 500, false);
          swiper2.slideTo(index, 500, false);
          //mySwiper.initialSlide=index;
      });
    }

    var swiper2 = new Swiper('.swiper2', {
        direction: 'horizontal',
        loop: false,
        autoHeight: true,
        slidesPerView: 1,
        onSlideChangeEnd: function (swiper) {
            var n = swiper.activeIndex;
            setCurrentSlide(document.querySelector(".swiper1 .swiper-slide").eq(n), n);
            swiper1.slideTo(n, 500, false);
        }
    });

});
