
<amp-lightbox id="filter-lightbox" [open]="showFilterLightbox" role="button" tabindex="0" layout="nodisplay" on="lightboxClose:AMP.setState({showFilterLightbox: false})">
    <div class="lightbox lgtBox">
        <div class="lgtBox-header">
            <div class="d-flex justify-content-between w-100">
                <div class="d-flex">
                    <amp-script layout="container" script="f-lgtBox-script">
                        <button id="f-lgtBox-back" class="mbutton" tabindex="0" type="button" aria-label="favorite">
                            <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#999999">
                                <path d="M15,5l-1.41,1.41L18.17,11H2V13h16.17l-4.59,4.59L15,19l7-7L15,5z" />
                            </svg>
                        </button>
                    </amp-script>
                    <script id="f-lgtBox-script" type="text/plain" target="amp-script">
                        const fButton = document.getElementById('f-lgtBox-back');
                    async function act() {
                        let ffilters = await AMP.getState('filters.index');
                        ffilters > 0 ? AMP.setState({filters : {index : -1 }}) : AMP.setState({showFilterLightbox : false});
                    }
                    fButton.addEventListener(
                        'click',
                        act
                    );
                </script>
                    <div class="lgtBox-title" [text]="filters.index > 0 ? filters.items.values[filters.index -1].title : 'فیلترها'">فیلترها</div>
                </div>
                <div>
                    <button class="mbutton" tabindex="0" type="button" aria-label="favorite" on="tap:AMP.setState({filters : {index : -1 }})">
                        پاک کردن
                    </button>
                </div>
            </div>
        </div>
        <div class="lgtBox-content">
            <div class="lgtBox-item">
                <div class="rs-container lightbox-container">
                    <amp-state id="filters">
                        <script type="application/json">
                            @json($changed_filters)
                        </script>
                    </amp-state>
                    <amp-state id="urlNavigated">
                    <script type="application/json">
                    {
                        "baseUrl": "{{url()->current()}}",
                        "url": "{!!str_replace(["%5B","%5D","&amp;"],["[","]","&"],url()->full())!!}"
                    }
                    </script>
                </amp-state>
                <amp-state id="sidebarPrice">
                    <script type="application/json">
                        {
                            "background" : {
                                "width" : 0,
                                "right" : 0
                            },
                            "from": 1000,
                            "to": 10000000,
                            "changeClass": false
                        }
                    </script>
                </amp-state>
                <amp-bind-macro id="numberFormat" arguments="num" expression="num"></amp-bind-macro>
                    <amp-list src="amp-state:filters" [src]="filters.index > 0 ? filters.items.values[filters.index -1] : filters.items" binding="always" height="1" width="200" layout="responsive" class="alch modelFullScr">
                        <template type="amp-mustache">
                            @{{#checkList}}
                                @{{#values}}
                                    <div class="f-item">
                                        <amp-script layout="container" script="f-lgtBox-input-script" >
                                            <label class="filter_checkbox">
                                                <span class="filter_checkbox_fa">@{{title}}</span>
                                                <span class="filter_checkbox_en">@{{name}}</span>
                                                <input aria-checked="true" id="@{{id}}" role="checkbox" type="checkbox" value="1" checked="checked" [checked]="@{{value}}" class="f-lgtBox-input">
                                                <span class="filter_checkbox_checkmark"></span>
                                            </label>
                                        </amp-script>
                                    </div>
                                @{{/values}}
                            @{{/checkList}}
                            
                            @{{^checkList}}
                                @{{#values}}
                                    @{{#price}}
                                    <amp-script layout="container" script="f-price-sidebar-script" >
                                    <div class="f-item">
                                   
                                    <div class="product-price-slider">
                                        <span>محدوده قیمت</span>
                                       
                                        <div class="price-slider">
                                            <div class="price-slider_bg" [aria-width]="sidebarPrice.background.width" [aria-right]="sidebarPrice.background.right"></div>
                                            <input id="minPrice" value="@{{minValue}}" min="@{{min}}" max="@{{max}}" step="@{{step}}" type="range" />
                                            <input id="maxPrice" value="@{{maxValue}}" min="@{{min}}" max="@{{max}}" step="@{{step}}" type="range" />
                                        </div>
                                        <div class="price-slider_holder">
                                            <div>
                                                <span class="price-slider_amount from" [text]="numberFormat(sidebarPrice.from)">@{{min}}</span>
                                                <span class="amount_unit">تومان</span>
                                            </div>
                                            <div>
                                                <span class="price-slider_amount to" [text]="numberFormat(sidebarPrice.to)">@{{max}}</span>
                                                <span class="amount_unit">تومان</span>
                                            </div>
                                        </div>
                                    </div>
                                    </div>
                                    </amp-script>
                                @{{/price}}

                                @{{^price}}
                                    @{{#switch}}
                                    <div class="f-item">
                                    <div class="card product-category-list">
                                        <div class="card_content">
                                            <div class=" d-flex align-items-center switch-row">
                                                <div class="input-icon d-flex">
                                                    <input name="@{{name}}" type="hidden" value="0">
                                                    <label class="el-switch el-switch-red">
                                                        <input class="no-checker js-filter-item" name="@{{name}}" type="checkbox" id="@{{name}}-1" value="1" >
                                                        <span class="el-switch-style"></span>
                                                    </label>
                                                </div>
                                                <span class="mr-2"> @{{title}}</span>
                                            </div>
                                        </div>
                                    </div>
                                    </div>
                                    @{{/switch}}
                                    @{{^switch}}
                                    <div class="f-item" on="tap:AMP.setState({filters : {index : @{{id}} }})" role="" tabindex="">
                                        <span>@{{title}}</span>
                                        <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#3E3E3E">
                                            <path d="M15.41 16.59L10.83 12l4.58-4.59L14 6l-6 6 6 6 1.41-1.41z"></path>
                                        </svg>
                                    </div>
                                    @{{/switch}}
                                    @{{/price}}
                                @{{/values}}
                                
                            @{{/checkList}}
                        </template>
                    </amp-list>
                    <script id="f-lgtBox-input-script" type="text/plain" target="amp-script">
                    var urlTask = {
                            url: window.location.pathname,
                            
                            setParam: function(name, id, value){
                                var thiz = this;
                                var param = name + "[" + id + "]";
                                if(value){
                                    thiz.add(-1 === thiz.url.indexOf("?") ? "?" : "&",param,id);
                                }else{
                                    var regex = new RegExp("([?&]" + thiz.escapeBrackets(param) + "=)[^&]+", "");
                                    if(regex.test(thiz.url))
                                        thiz.remove(regex);
                                }
                            },
                            add: function(sign, param, value) {
                                this.url += sign + param + "=" + encodeURIComponent(value)
                            },                            
                            remove: function(regex) {
                                this.url = this.url.replace(regex, "")
                            },
                            escapeBrackets: function(t) {
                                return t.replace(/[[]/g, "\\[").replace(/]/g, "\\]")
                            }
                        }
                        
                        const fInput = document.getElementsByClassName('f-lgtBox-input');
                        async function act2(event) {
                            let ffilters = await AMP.getState('filters');
                            let urlNavigated = await AMP.getState('urlNavigated');
                            ffilters = JSON.parse(ffilters);
                            urlNavigated = JSON.parse(urlNavigated);
                            const id = parseInt(event.currentTarget.getAttribute('id'));
                            ffilters.items.values[ffilters.index-1].values[id-1].value = !ffilters.items.values[ffilters.index-1].values[id-1].value;
                            AMP.setState({filters : ffilters})
                            urlTask.url = urlNavigated.url;
                            urlTask.setParam(ffilters.items.values[ffilters.index-1].name,ffilters.items.values[ffilters.index-1].values[id-1].id,ffilters.items.values[ffilters.index-1].values[id-1].value);
                            urlNavigated.url = urlTask.url;
                            console.log(urlNavigated.url);
                            AMP.setState({urlNavigated : urlNavigated});
                            
                        }
                        fInput.forEach( inp => inp.addEventListener('change',act2))
                    </script>
                    
                    <script id="f-price-sidebar-script" type="text/plain" target="amp-script">
                    function initFilterRange() {
                        console.log(2000);
                        var parent = document.querySelector(".product-price-slider");
                        if (!parent) return;
                        var
                            rangeS = parent.querySelectorAll("input[type=range]"),
                            from = parent.querySelectorAll(".from"),
                            to = parent.querySelectorAll(".to"),
                            bg = parent.querySelectorAll(".price-slider_bg");

                        setData();
                        rangeS.forEach(function (el) {
                            el.oninput = function (e) {
                                setData();
                                AMP.setState({sidebarPrice : {'changeClass' : true}});
                            }
                        });

                        async function setData() {
                            var slide1 = parseFloat(rangeS[0].value),
                                slide2 = parseFloat(rangeS[1].value);
                            slide1 = isNaN(slide1) ? 0 : slide1;
                            slide2 = isNaN(slide2) ? 0 : slide2;
                            if (slide1 > slide2) {
                                [slide1, slide2] = [slide2, slide1];
                            }
                            var rangeOffset = await rangeS[0].getBoundingClientRectAsync();
                            var width =rangeOffset.width,
                                max = rangeS[0].max,
                                min = rangeS[0].min;
                            
                            
                            var bgRight = (slide1 / max) * width ;
                            var bgWidth = ((slide2 - slide1) / max) * width ;
                            console.log(slide1,max,width);
                            AMP.setState({sidebarPrice : {'background' : {'width': bgWidth, 'right': bgRight}}});

                            //from[0].innerText = slide1.toFixed(0).replace(/\d(?=(\d{3})+\.)/g, '$&,');
                            //from[0].setAttribute('data-value',slide1.toFixed(0));
                            AMP.setState({sidebarPrice : {'from' : slide1.toFixed(0)}});

                            //to[0].innerText = slide2.toFixed(0).replace(/\d(?=(\d{3})+\.)/g, '$&,');
                            //to[0].setAttribute('data-value',slide2.toFixed(0));
                            AMP.setState({sidebarPrice : {'to' : slide2.toFixed(0)}});
                            
                        }

                        [from, to].forEach(function (el) {
                            el.oninput = function () {
                                var number1 = parseFloat(from.value),
                                    number2 = parseFloat(to.value);

                                if (number1 > number2) {
                                    var tmp = number1;
                                    from.value = number2;
                                    to.value = tmp;
                                }

                                rangeS[0].value = number1;
                                rangeS[1].value = number2;

                            }
                        });
                    }
                    initFilterRange();
                    </script>
                    <div class="fpb-script">
                        <a class="filter-apply-btn mbutton" [href]="urlNavigated.url" id="fpb-script-btn">جستجوی پیشرفته</a>
                    </div>
                </div>
            </div>
        </div>

    </div>
    </div>
</amp-lightbox>