@foreach($changed_filters['items']['values'] ?? [] as $item)
@if(@$item['checkList'])
<div class="card product-category-list">
    <div class="cart_title">
        {{$item['title']}}
    </div>
    <div class="card_content">
        @foreach($item['values'] as $fitem)
        <div class="f-item">
            <label class="filter_checkbox">
                <span class="filter_checkbox_fa">{{$fitem['title']}}</span>
                <span class="filter_checkbox_en">{{$fitem['name']}}</span>
                <input name="{{$item['name']}}[]" aria-checked="true" role="checkbox" type="checkbox" id="{{$item['name']}}-{{$fitem['id']}}" value="{{$fitem['id']}}" class="f-lgtBox-input js-filter-item" @if($fitem['value']) checked @endif>
                <span class="filter_checkbox_checkmark"></span>
            </label>
        </div>
        @endforeach
    </div>
</div>
@elseif(@$item['price'])
<div class="card product-price-slider">
    <div class="cart_title">
        {{$item['title']}}
    </div>
    <div class="card_content">
        <div class="price-slider">
            <div class="price-slider_bg"></div>
            <input id="minPrice" value="{{@$item['minValue'] ?? $item['min']}}" min="{{$item['min']}}" max="{{$item['max']}}" step="{{$item['step']}}" type="range" />
            <input id="maxPrice" value="{{@$item['maxValue'] ?? $item['max']}}" min="{{$item['min']}}" max="{{$item['max']}}" step="{{$item['step']}}" type="range" />
        </div>
        <div class="price-slider_holder">
            <div>
                <span class="price-slider_amount from">{{number_format($item['min'])}}</span>
                <span class="amount_unit">تومان</span>
            </div>
            <div>
                <span class="price-slider_amount to">{{number_format($item['max'])}}</span>
                <span class="amount_unit">تومان</span>
            </div>
        </div>
        <button class="apply-price-btn btn js-price-filter">اعمال قیمت </button>
    </div>
</div>
@elseif(@$item['switch'])
<div class="card product-category-list">
    <div class="card_content">
        <div class=" d-flex align-items-center switch-row">
            <div class="input-icon">
                <input name="{{$item['name']}}" type="hidden" value="0">
                <label class="el-switch el-switch-red">
                    <input class="no-checker js-filter-item" name="{{$item['name']}}" type="checkbox" id="{{$item['name']}}-1" value="1" @if($item['value']) checked @endif>
                    <span class="el-switch-style"></span>
                </label>
            </div>
            <span class="ml-3"> {{$item['title']}}</span>
        </div>
    </div>
</div>
@endif
@endforeach