function Url(t){void 0===t&&(t=window.location.pathname+window.location.search+window.location.hash),this.url=decodeURIComponent(t),this.params}Url.prototype={setParam:function(t,r){var e=this,n=new RegExp("([?&]"+e.escapeBrackets(t)+"=)[^&]+","");return 0===r.length||(-1===e.url.indexOf("?")?e.add("?",t,r):n.test(e.url)?e.change(n,r):e.add("&",t,r)),e.url},setParams:function(t){var s=this,o=function(t,r,e){var n,i;for(var a in t)t.hasOwnProperty(a)&&(n=e?r?r+a:a:r?r+"["+a+"]":a,"object"==typeof(i=t[a])?o(i,n):s.setParam(n,i))};o(t,"",!0)},getParams:function(){for(var t,r=/[?&]([^=#]+)=([^&#]*)/g,e={};t=r.exec(this.url);)e[t[1]]=t[2];return e},removeParam:function(t){var r=this.url.split("?")[0],e=[],n=-1!==this.url.indexOf("?")?this.url.split("?")[1]:"";if(""!==n){for(var i=(e=n.split("&")).length-1;0<=i;i-=1)e[i].split("=")[0]===t&&e.splice(i,1);var a=e.join("&");this.url=r+(a.length?"?":"")+a}return this.url},addHash:function(t){var r=this.url.split("#");r[1]?this.url=this.url.replace(r[1],t):this.url=this.url+"#"+t},getHash:function(){var t=this.url.split("#");return!!t[1]&&t[1]},getParam:function(t,r){return this.params||(this.params=this.getParams()),void 0!==this.params[t]?this.params[t]:r},getUrl:function(){return decodeURI(this.url)},add:function(t,r,e){this.url+=t+r+"="+encodeURIComponent(e)},change:function(t,r){this.url=this.url.replace(t,"$1"+encodeURIComponent(r))},escapeBrackets:function(t){return t.replace(/[[]/g,"\\[").replace(/]/g,"\\]")},update:function(){history.pushState({},null,this.getUrl())}};

document.addEventListener("DOMContentLoaded", function(event) {
    filterClass.init();
 });

var filterClass = {
    queryRemoved:false,

    init: function(){
        this.initFilterRange();
        this.initSortOptions();
        this.initFilterControls();
    },

    initFilterRange: function () {
        var parent = document.querySelector(".product-price-slider");
        if (!parent) return;
        var
            rangeS = parent.querySelectorAll("input[type=range]"),
            from = parent.querySelectorAll(".from"),
            to = parent.querySelectorAll(".to"),
            bg = parent.querySelectorAll(".price-slider_bg");

        setData();
        rangeS.forEach(function (el) {
            el.oninput = function (e) {
                setData();
                from[0].classList.add('changed');
                to[0].classList.add('changed');
            }
        });

        function setData() {
            var slide1 = parseFloat(rangeS[0].value),
                slide2 = parseFloat(rangeS[1].value);

            if (slide1 > slide2) {
                [slide1, slide2] = [slide2, slide1];
            }

            var width = rangeS[0].offsetWidth,
                max = rangeS[0].max,
                min = rangeS[0].min;


            bg[0].style.right = (slide1 / max) * width + "px";
            bg[0].style.width = ((slide2 - slide1) / max) * width + "px";

            from[0].innerText = slide1.toFixed(0).replace(/\d(?=(\d{3})+\.)/g, '$&,');
            from[0].setAttribute('data-value',slide1.toFixed(0));
           
            to[0].innerText = slide2.toFixed(0).replace(/\d(?=(\d{3})+\.)/g, '$&,');
            to[0].setAttribute('data-value',slide2.toFixed(0));
            
        }

        [from, to].forEach(function (el) {
            el.oninput = function () {
                var number1 = parseFloat(from.value),
                    number2 = parseFloat(to.value);

                if (number1 > number2) {
                    var tmp = number1;
                    from.value = number2;
                    to.value = tmp;
                }

                rangeS[0].value = number1;
                rangeS[1].value = number2;

            }
        });
    },

    initSortOptions: function() {
        
        var sortItems = document.querySelectorAll('.sort_content .sort_item');
        
        for(var i=0; i<sortItems.length; i++){
            sortItems[i].addEventListener('click', function (e) {
                var sortItemsTemp = document.querySelectorAll('.sort_content .sort_item.active');
                for(var j=0; j<sortItemsTemp.length;j++){
                    sortItemsTemp[j].classList.remove('active');
                }
                e.currentTarget.classList.add('active');
                filterClass.getProductsForFilters();
            });
        }
    },

    initFilterControls: function () {
        url = new Url(window.location.pathname + window.location.search);
        var clearAllElm = document.querySelector('.js-listing-options-clear');
        if(clearAllElm){
            clearAllElm.addEventListener('click', function (e) {
                e.preventDefault();
                document.querySelector('input[name=filterSearchInput]').value = '';
                this.queryRemoved = true;
    
                var checked = document.querySelectorAll('input.js-filter-item:checked');
                if (checked.length) {
                    for(var i=0; i<checked.length; i++){
                        checked[i].checked =  false;
                    }
                }
    
                url = new Url(window.location.pathname);
                window.location.href = url;
            });
        }
        
        var clearElm = document.querySelector('.js-listing-option-remove');
        if(clearElm){
            clearElm.addEventListener('click', function (e) {
                
                var key = e.currentTarget.getAttribute('data-key');
                if (key === 'filterSearchInput') {
                    document.querySelector('input[name=filterSearchInput]').value = '';
                    filterClass.queryRemoved = true;
                } else if (key === 'price') {
                    $('input[name="price[min]"], input[name="price[max]"]').val('').attr('data-value', '');
                    filterClass.preparePriceFilter();
                } else {
                    var temp = document.querySelector('#' + key + '-' + e.currentTarget.getAttribute('data-value'));
                    if(temp) temp.checked = false;
                }
                e.currentTarget.closest('li').remove();
                filterClass.getProductsForFilters();
            });    
        }
        
        var inputs = document.querySelectorAll('input.js-filter-item');
        for(var i=0; i< inputs.length; i++){
            inputs[i].addEventListener('change', function (e) {
                filterClass.getProductsForFilters(1);
            });
        }
        
        var searchElm = document.querySelector('input[name=filterSearchInput]');
        if(searchElm){
            searchElm.addEventListener('keyup', function (e) {
                if (e.keyCode === 13) {
                    filterClass.getProductsForFilters();
                }
            });
        }

        var filterElm = document.querySelector('.js-price-filter');
        if(filterElm){
            filterElm.addEventListener('click',  function () {
                filterClass.getProductsForFilters(1);
            });
        }
        
    },
    
    preparePriceFilter: function() {
        
        if (val = $('input[name="price[min]"]').attr('data-value')) {
            val = parseInt(val);
            if (!!val) {
                thiz.url.setParams({price: {min: val}});
                $('.js-min-price').val(val).prop('checked', true);
            }
        }
    
        if (val = $('input[name="price[max]"]').attr('data-value')) {
            val = parseInt(val);
            if (!!val) {
                thiz.url.setParams({price: {max: val}});
                $('.js-max-price').val(val).prop('checked', true);
            }
        }
    
        if (!thiz.priceFilterUpdated) {
            $('.js-max-price, .js-min-price').prop('checked', false);
        }
    },
    
    getProductsForFilters: function (page) {
        var tempValue;
        var checkboxParams = {};
        var queryRemoved = false;
    
        var newUrl = new Url(window.location.pathname); //thiz
        var lastUrl = new Url(window.location.search);
    
        var checkedInput = document.querySelectorAll('input.js-filter-item:checked');
        for(var i=0; i< checkedInput.length; i++){
            var name = checkedInput[i].getAttribute('name');
            if (name.slice(-2) === '[]') {
                name = name.slice(0, -2);
                if (typeof checkboxParams[name] === 'undefined') {
                    checkboxParams[name] = [];
                }
                checkboxParams[name].push(checkedInput[i].value);
            } else {
                checkboxParams[name] = checkedInput[i].value;
            }
        }

        var from = document.querySelector(".from.changed"),
            to = document.querySelector(".to.changed");
        
        if(from){
            checkboxParams['price[min]'] = from.getAttribute('data-value');
        }
        if(to){
            checkboxParams['price[max]'] = to.getAttribute('data-value');
        }
        
        if (checkboxParams) {
            newUrl.setParams(checkboxParams);
        }
    
        var searchElm = document.querySelector('input[name=filterSearchInput]');
        tempValue = searchElm.value;
        if ((tempValue || (!queryRemoved && lastUrl.getParam('q')))) {
            newUrl.setParam('q', (!!lastUrl.getParam('q') && lastUrl.getParam('q') !== tempValue ? lastUrl.getParam('q') + ' ' : '') + tempValue);
            searchElm.value = '';
        } else {
            queryRemoved = false;
        }
    
        if (page) {
            newUrl.setParam('pageno', page);
        }
    
        tempValue = document.querySelector('.sort_content .sort_item.active').getAttribute('data-sort');
        if (tempValue) {
            newUrl.setParam('sortby', tempValue);
        }
    
        window.location.href = newUrl.getUrl();
    }
};





