document.addEventListener("DOMContentLoaded", function (event) {
    var swiper = new Swiper('.swiper-amp-iconRow', {
        // Optional parameters
        slidesPerView: 2,
        spaceBetween: 20,
        loop: true,
        autoplay: {
            delay: 10000
        },

        breakpoints: {
            640: {
                slidesPerView: 4,
                spaceBetween: 20,
            },
            768: {
                slidesPerView: 5,
                spaceBetween: 20,
            },
            1024: {
                slidesPerView: 6,
                spaceBetween: 20,
            },
            1366: {
                slidesPerView: 7,
                spaceBetween: 30,
            },
        },
        // Navigation arrows
        navigation: {
            nextEl: '.swiper-amp-iconRow .swiper-button-next',
            prevEl: '.swiper-amp-iconRow .swiper-button-prev',
        }
    });
});
