document.addEventListener("DOMContentLoaded", function (event) {
    CommentClass.init();
});

var CommentClass = {
    queryRemoved: false,

    init: function () {
        //this.initScroll();
        this.initReply();
        this.initCancelReply();
        this.initAddComment();
    },

    initScroll: function () {
        window.addEventListener('scroll', function () {
            scrollProgressBar();
        });
    },

    initReply: function () {
        var cmntRplyBtn = document.querySelectorAll('.comment-reply-link');
        if (cmntRplyBtn) {
            for (var i = 0; i < cmntRplyBtn.length; i++) {
                cmntRplyBtn[i].addEventListener("click", (event) => {
                    event.preventDefault();
                    event.stopPropagation();
                    
                    var parentid = event.currentTarget.getAttribute('data-commentid');
                    var postid = event.currentTarget.getAttribute('data-postid');
                    var type = event.currentTarget.getAttribute('data-type');
                    var commentItem = event.currentTarget.closest('.comment-item.box-frame');
                    var captcha = '';

                    var replyExist = commentItem.querySelectorAll('.js-reply-comment');
                    if (replyExist.length) {
                        replyExist.remove();
                        document.querySelector('.js-new-comment').classList.remove('d-none');
                        return;
                    }

                    var replyCmnt = document.querySelectorAll('.js-reply-comment');
                    if(replyCmnt){
                        for (var i = 0; i < replyCmnt.length; i++) {
                            replyCmnt[i].remove();
                        }
                    }

                    function done(event) {
                        captcha = JSON.parse(event);
                        var commentAdd = `
                            <div class="row mt-3 js-reply-comment">
                            <div class="col-12">
                                <div class="comment-item box-frame2">
                                    <form class="js-comment-form" method="post" action="/Comment/addComment">				
                                        <input type="hidden" name="id" value="` + postid + `">
                                        <input type="hidden" name="type" value="` + type + `">
                                        <input type="hidden" name="parent" value="` + parentid + `">
                                        <textarea class="c-ui-textarea" name="commentDesc" placeholder="لطفاً دیدگاهتان را اینجا درج نمایید. دیدگاه شما پس از بررسی، نمایش داده می شود."></textarea>
                                        <div class="comment-action d-flex">
                                            <img src=` + captcha + `>
                                            <input name="captcha" maxlength="8" type="text" value="" placeholder="کد امنیتی" required="">
                                            <button class="btn btn-danger js-comment-add-new" type="submit">
                                                <span>ثبت و ارسال نظر</span>
                                            </button>
                                            <button class="btn btn-dark js-comment-cancel-reply mr-2">
                                                <span>لغو پاسخ</span>
                                            </button>
                                        </div>
                                        
                                    </form>
                                </div>
                            </div>
                        </div>
                            `;

                        commentItem.innerHTML += commentAdd;
                        document.querySelector('.js-new-comment').classList.add('d-none');
                        CommentClass.initAddComment();
                        CommentClass.initCancelReply();
                    };

                    function fail(event) {
                        Utility.notify('امکان پاسخ به این نظر وجود ندارد. لطفا دوباره تلاش نمائید.', 'danger');
                    };

                    Utility.sendAjax({}, '/ajax_regen_captcha', done, fail,'GET');

                });
            }

        }
    },

    initCancelReply: function () {
        var cmntCancelBtn = document.querySelector('.js-comment-cancel-reply');
        if (cmntCancelBtn) {
            cmntCancelBtn.addEventListener('click', (event) => {
                event.currentTarget.closest('.js-reply-comment').remove();
                document.querySelector('.js-new-comment').classList.remove('d-none');
            })
        }
    },

    initAddComment: function () {
        var cmntAddBtn = document.querySelectorAll('.js-comment-add-new');
        if (cmntAddBtn) {
            for (var i = 0; i < cmntAddBtn.length; i++) {
                cmntAddBtn[i].addEventListener("click", (event) => {
                    event.preventDefault();
                    var currentForm = event.currentTarget.closest('.js-comment-form');
                    
                    function done(event) {
                        console.log(event);
                        document.querySelector('#commentModal .cart-alert-icon').classList.add('success');
                        document.querySelector('#commentModal .cart-alert-icon i').classList.add('icon-check');
                        document.querySelector('#commentModal .cart-alert-icon').classList.remove('failed');
                        document.querySelector('#commentModal .cart-alert-icon i').classList.remove('icon-close');
                        document.querySelector('#commentModal .cart-alert-text').innerHTML = (JSON.parse(event).message);
                        document.querySelector('#commentModal').modal('show');
                    }
                    function fail(event) {
                        event = JSON.parse(event);
                        if (event.status == 401) {
                            document.getElementById('loginModal').modal('show');
                            return;
                        }
                        document.querySelector('#commentModal .cart-alert-icon').classList.remove('success');
                        document.querySelector('#commentModal .cart-alert-icon i').classList.remove('icon-check');

                        document.querySelector('#commentModal .cart-alert-icon').classList.add('failed');
                        document.querySelector('#commentModal .cart-alert-icon i').classList.add('icon-close');
                        if (typeof event.message == 'object') {
                            document.querySelector('#commentModal .cart-alert-text').innerHTML = (" ");
                            for (const property in event.message) {
                                document.querySelector('#commentModal .cart-alert-text').innerHTML += (event.message[property] + " </br>");
                              }
                            
                        } else
                            document.querySelector('#commentModal .cart-alert-text').text(event.message);

                        document.querySelector('.comment-action img').setAttribute('src', event.captcha);
                        document.getElementById('commentModal').modal('show');
                    };
                    var formInputs = currentForm.elements;
                    var data = {};
                    for (var i = 0; i< formInputs.length ; i++) {
                        if (formInputs[i].nodeName === "INPUT" || formInputs[i].nodeName === "TEXTAREA")
                            data[formInputs[i].name] = formInputs[i].value;
                    }
                    
                    Utility.sendAjax( data, '/comment/addComment', done, fail);

                })
            }
        }

    },

    addRating: function () {
        $(document).on('click', '.js-article-add-rating', function (event) {
            const id = $(event.currentTarget).data("id")
            const type = $(event.currentTarget).data("type")
            let thisElement = $(event.currentTarget)
            event.preventDefault();
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'POST',
                url: '/Blog/addRating',
                data: {
                    articleid: id,
                    type: type
                },

                error: function (xhr, ajaxOptions, thrownError) {

                    if (xhr.status == 401) {
                        $('#loginModal').modal('show');
                        return;
                    } else
                        alert(xhr.responseJSON.message);
                },

                success: function (data) {
                    $('.js-article-add-rating').removeClass('active');
                    thisElement.addClass('active');
                    $('.kt-like-button').find('span').html(DigitHelper.writeNumber(data.like));
                    $('.kt-dislike-button').find('span').html(DigitHelper.writeNumber(data.dislike));
                }
            });

        });
    },

    scrollComment: function () {
        $(document).on('click', '.blog-single-meta-comments', function (event) {
            $('html, body').animate({
                scrollTop: $(".blog-comment-section").offset().top - 100
            }, 1000, function () {});
        });
    },

    scrollProgressBar: function () {
        if ($('.scroll-progress-bar').length) {
            var height = $('.blog-detail-content').outerHeight() + $('#BreadCrumb').outerHeight() - ($(window).outerHeight() * 1.38) + ($('body').hasClass('admin-bar') ? 32 : 0),
                width = (($(window).scrollTop() - $('#BreadCrumb').offset().top + ($(window).outerHeight() * 0.12)) / height) * 100;
            if (width > 100) width = 100;
            if (width < 0) width = 0;
            $('.scroll-progress-bar').css('width', width + '%');
        }
    }

}
