<ul class="product-detail-options">
    <li>
        <button class="btn-option js-product-add-favorite @if(Auth::user() && Auth::user()->favorites->contains($product->id)) active @endif" data-id="{{$product->id}}">
        <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#000000"><path d="M0 0h24v24H0z" fill="none"/><path d="M17 3H7c-1.1 0-1.99.9-1.99 2L5 21l7-3 7 3V5c0-1.1-.9-2-2-2zm0 15l-5-2.18L7 18V5h10v13z"/></svg>
        </button>
    </li>
</ul>

<div class="p-img_holder">
    <div class="img-zoom-lens" id="imgLens"></div>
    <div class="p-img_large" id="myimage">
        <div class="img-zoom-container">
            <img id="aaa" src="{{'/pic/product/' . $product->id . 'w350h350c1/' . $product->id . '.png'}}">
        </div>
    </div>
    <div class="p-img_thumbnail_holder">
        @for ($i = 0; $i < min($gallery->count(),4); $i++)
            <div class="p-img_thumbnail_item">
                <img src="{{'/pic/product.gallery/' . $gallery[$i]->id . 'w90h90c1/' . $gallery[$i]->id . '.jpg?nocache=1'}}" data-toggle="modal" data-target="productGalleryModal">
            </div>
        @endfor
        @if($gallery->count() - 4 > 0)
        <div class="p-img_thumbnail_item">
            +{{$gallery->count() - 4}}
        </div>
        @endif
    </div>
</div>

<div id="myresult" class="img-zoom-result"></div>

<script>
    function imageZoom(imgID, resultID) {
        var img, lens, result, cx, cy;
        img = document.getElementById(imgID);
        result = document.getElementById(resultID);
        /* Create lens: */
        lens = document.getElementById("imgLens");

        /*set result width */
        var pdInfoHolder = document.getElementsByClassName("pd_info_holder")[0];
        var pdImgHolder = document.getElementsByClassName("p-img_holder")[0];
        
        
        result.style.width = (pdInfoHolder.offsetWidth - 40) + "px";
        result.style.height = (pdInfoHolder.offsetHeight) + "px";
        result.style.right = (pdImgHolder.offsetWidth + 55) + "px";
        
        /* Calculate the ratio between result DIV and lens: */
        cx = (pdInfoHolder.offsetWidth - 40) / lens.offsetWidth;
        cy = pdInfoHolder.offsetHeight / lens.offsetHeight;
        /* Set background properties for the result DIV */

        result.style.backgroundImage = "url('" + img.querySelectorAll("img")[0].src.replace(/ *(?:w\d+)|(?:h\d+)|c1 */g, "").replace(/ *(\d*)\.png/g,"$1-fullsize") + "')";
        result.style.backgroundSize = (img.offsetWidth * cx) + "px " + (img.offsetHeight * cy) + "px";


        /* Execute a function when someone moves the cursor over the image, or the lens: */
        lens.addEventListener("mousemove", moveLens);
        img.addEventListener("mousemove", moveLens);
        /* And also for touch screens: */
        lens.addEventListener("touchmove", moveLens);
        img.addEventListener("touchmove", moveLens);

        function moveLens(e) {
            var pos, x, y;
            /* Prevent any other actions that may occur when moving over the image */
            e.preventDefault();
            /* Get the cursor's x and y positions: */
            pos = getCursorPos(e);

            if (pos.x >= 0 && pos.y >= 0) {
                result.style.display = "block";
                lens.style.opacity = 0.4;
            }
            if (pos.x < 30 || pos.x > img.offsetWidth - 30 || pos.y < 30 || pos.y > img.offsetHeight - 30) {
                result.style.removeProperty("display");
                lens.style.opacity = 0;
            }
            /* Calculate the position of the lens: */
            x = pos.x - (lens.offsetWidth / 2);
            y = pos.y - (lens.offsetHeight / 2);
            /* Prevent the lens from being positioned outside the image: */
            if (x > img.offsetWidth - lens.offsetWidth) {
                x = img.offsetWidth - lens.offsetWidth;
            }
            if (x < 0) {
                x = 0;
            }
            if (y > img.offsetHeight - lens.offsetHeight) {
                y = img.offsetHeight - lens.offsetHeight;
            }
            if (y < 0) {
                y = 0;
            }
            // console.log(img.offsetWidth,lens.offsetWidth,x);
            /* Set the position of the lens: */
            lens.style.left = x + "px";
            lens.style.top = y + "px";
            /* Display what the lens "sees": */
            result.style.backgroundPosition = "-" + (x * cx) + "px -" + (y * cy) + "px";
        }

        function getCursorPos(e) {
            var a, x = 0,
                y = 0;
            e = e || window.event;

            a = img.getBoundingClientRect();
            
            x = e.pageX - a.left;
            y = e.pageY - a.top;

            x = x - window.pageXOffset;
            y = y - window.pageYOffset;

            if (y > 0 && y < img.offsetHeight)
                return {
                    x: x,
                    y: y
                };
        }
    };
    document.addEventListener("DOMContentLoaded", function(event) {
        imageZoom("myimage", "myresult");
    })
</script>