<div class="row">
    <div class="col-9">
        <ul class="pd_tabs">
            <li class="pd_tab is-active" data-fetchfromservice="" data-method="desc" id="tab-desc">
                <a href="#">نقد و بررسی</a>
            </li>
            <li class="pd_tab" data-fetchfromservice="" data-method="params" id="tab-params">
                <a href="#">مشخصات</a>
            </li>
            <li class="pd_tab" data-fetchfromservice="1" data-method="comments" id="tab-comments" data-items-count="704">
                <a href="#">دیدگاه کاربران</a>
            </li>
        </ul>
        <div class="pd_taps_content_desc is-active" id="home" role="tabpanel" aria-labelledby="home-tab">
            <div class="pd_taps_header">--نقد و بررسی</div>
            {!! $product->description!!}
        </div>

        <div class="pd_taps_content_scpec" id="home" role="tabpanel" aria-labelledby="home-tab">
            <div class="pd_taps_header">-- مشخصات کلی </div>

            @foreach ($product->specifications()->where('xstatus',1)->get() as $item)
            @if($item->value)
            <div class="list-group-item d-flex justify-content-between">
                <div class="row w-100">
                    <div class="col-3">
                        <h3>{{$item->name}}</h3>
                    </div>
                    <div class="col-9">
                        <span>{{$item->value}}</span>
                    </div>
                </div>
            </div>
            @else
            <div class="list-group-item d-flex">
                <h4>
                    <i class="icon-threeangle-right"></i>
                    {{$item->name}}
                </h4>
            </div>
            @endif
            @endforeach
        </div>

        <div class="pd_taps_content_comment" id="home" role="tabpanel" aria-labelledby="home-tab">
            <div class="pd_taps_header">-- دیدگاه کاربران </div>
            @include('widget::amp-comment.desktop.commentList',[
            'type'=>'product',
            'pageWidgetId'=>$product->id,
            'externalData' =>['comments' => $comments]
            ])

        </div>

    </div>
    <div class="col-3">
        <div class="buy-box-fixed">
            <div class="pd_info_box buy-box">
                <div class="buy-box_info">
                    <img src="{{'/pic/product/' . $product->id . 'w80h80c1/' . $product->id . '.png'}}">
                    <span>{{$product->name}}</span>
                </div>
                @include('shop::index.desktop.detail_icon')
                @include('shop::index.desktop.price')
                @if((int)@$gsPartBalance['legalAvail'] > 0 && @$product->xstatus)
                <button class="btn add-to-cart" type="submit" data-id="{{$product->id}}">
                    <span> اضافه به سبد خرید </span>
                    <i class="icon-wallet"></i>
                </button>
                @endif

            </div>
        </div>
    </div>
</div>

<script>
    var milestones = document.getElementsByClassName('pd_taps_header'),
        items = document.querySelectorAll('.pd_tabs li'),
        scrollTarget = false,
        headerOffset = 70;

    function getIndex(elem) {
        var i = 0;
        while ((elem = elem.previousSibling) != null) {
            if (elem.nodeType == 1) {
                ++i;
            }
        }
        return i;
    }

    function hasClass(className, element) {
        if ((" " + element.className + " ").replace(/[\n\t]/g, " ").indexOf(" " + className + " ") > -1) {
            return true;
        }
        return false;
    }

    for (var i = 0; i < items.length; i++) {
        items[i].addEventListener("click", function(event) {

            event.preventDefault();
            event.stopPropagation();

            var li = event.currentTarget,
                index = getIndex(li),
                milestone = milestones[index];

            if (!hasClass('is-active', li) && milestone) {

                for (i = 0; i < items.length; ++i) {
                    items[i].classList.remove("is-active");
                }
                li.classList.add("is-active");
                scrollTarget = index;


                var elementPosition = milestone.getBoundingClientRect().top + window.scrollY;
                var offsetPosition = elementPosition - headerOffset;

                function onScrollTarget() {
                    if (scrollTarget !== false) {
                        var elementPosition = milestones[scrollTarget].getBoundingClientRect().top + window.scrollY;
                        var offsetPosition = elementPosition - headerOffset;

                        if (window.pageYOffset.toFixed() === offsetPosition.toFixed()) {
                            window.removeEventListener('scroll', onScrollTarget)
                            scrollTarget = false;
                        }
                    }

                }

                document.addEventListener('scroll', onScrollTarget)
                window.scrollTo({
                    top: offsetPosition,
                    behavior: "smooth"
                });
            }
        }, true);
    }

    document.addEventListener('scroll', function() {
        var active = -1;

        if (scrollTarget === false) {
            for (var i = 0; i < milestones.length; i++) {
                var elementPosition = milestones[i].getBoundingClientRect().top;
                if (elementPosition < 70) {
                    active++;
                }
            }
        } else {
            active = scrollTarget;
        }

        if (active != -1) {
            for (i = 0; i < items.length; ++i) {
                items[i].classList.remove("is-active");
            }
            items[active].classList.add("is-active");
        }

    })
</script>