@section('content')
<div class="shop-body pt-3">
    <div class="container">
        @include('shop::index.breadcrumb')
        <div class="card">
            <div class="row">
                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 clear_xs dir-ltr pd_gallery_holder">
                    @include('shop::index.imageBox')
                </div>
                <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12 clear_xs pd_info_holder">
                    <div class="shop-product-detail">
                        <h1>{{$product->name}}</h1>
                        <div class="row">
                            <div class="col-12 col-md-7 ">
                                <div class="shop-product-detail-group mb-2 d-flex">
                                    <div class="mr-5">
                                        <span>برند: </span>
                                        <span>{{@$product->brand->name}}</span>
                                    </div>
                                    <div>
                                        <span>دسته: </span>
                                        <span>{{@$product->group->name}}</span>
                                    </div>
                                </div>
                                <div class="shop-product-detail-color mb-2 d-flex">
                                    <span>مدل: </span>
                                    <span>{{$product->model}}</span>
                                </div>
                                <div class="shop-product-detail-color mb-2 d-flex">
                                    <span> قابل استفاده در مدل های: </span>
                                    <span class="ml-1 pt-1"> {{implode(' ،',$product->otherModel->take(2)->pluck('model')->toArray())}}</span>
                                    <a class="ml-2 btn-link-spoiler js-more-otherModel-button" href="#"> بیشتر...</a>
                                </div>
                                <div class="shop-product-detail-warranty d-flex">
                                    <span> گارانتی: </span>
                                    <span>{{$product->warranty}}</span>
                                </div>

                            </div>
                            <div class="col-12 col-md-5  shop-product-detail-futures">
                                <div class="shop-product-detail-price">
                                    @var('gsPartBalance',$product->sync ? $product->getGSPrice() : $product->getFastGSPrice())
                                    @var('productDiscount',$product->discountPrice())
                                    @if((int)@$gsPartBalance['legalAvail'] > 0 && @$product->xstatus)
                                    <div class="product-detail-price">
                                        @if($productDiscount && $productDiscount['price'])
                                        <span class="title-price-old">{{FarsiLib::convertDigit(number_format($gsPartBalance['customerPrice']))}}</span>
                                        <span>{{FarsiLib::convertDigit(number_format($gsPartBalance['customerPrice'] - $productDiscount['price']))}} تومان </span>
                                        @else @if($gsPartBalance['customerPrice'])
                                        <span>{{FarsiLib::convertDigit(number_format($gsPartBalance['customerPrice']))}} تومان </span> @else
                                        <span>رایگان</span> @endif @endif
                                    </div>

                                    <button class="btn btn-danger button-add-cart add-to-cart" type="submit" data-id="{{$product->id}}">
                                        <span> اضافه به سبد خرید </span>
                                        <i class="icon-wallet"></i>
                                    </button>
                                    @else
                                    <div class="d-flex product-detail-out-of-stock flex-column">
                                        <div class="out-of-stock-title d-flex">
                                            ناموجود
                                        </div>
                                        <div class="out-of-stock-body">
                                            متاسفانه این کالا در حال حاضر موجود نیست. می‌توانید از طریق لیست پائین صفحه، از محصولات مشابه این کالا دیدن نمایید
                                        </div>
                                        <button class="btn btn-dark js-add-to-notify-button" type="submit" data-id="{{$product->id}}">
                                            موجود شد به من اطلاع بده
                                        </button>
                                    </div>
                                    @endif
                                </div>
                            </div>

                        </div>
                        <hr>
                    </div>

                    <div class="shop-product-abstract">
                        {{Str::words($product->abstract,125)}}
                    </div>
                </div>
            </div>
        </div>

        <ul class="nav nav-tabs mt-4 product-detail-tab-header" id="myTab" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">نقد وبررسی</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">مشخصات فنی</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="contact-tab" data-toggle="tab" href="#contact" role="tab" aria-controls="contact" aria-selected="false">نظرات کاربران</a>
            </li>
        </ul>
        <div class="tab-content product-detail-tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                {!! $product->description!!}
            </div>
            <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                <div class="product-fields">
                    @foreach ($product->specifications()->where('xstatus',1)->get() as $item)
                    @if($item->value)
                    <div class="row no-gutters product-field">
                        <div class="col-12 col-sm-3">
                            <h6 class="product-field-name">
                                {{$item->name}}
                            </h6>
                        </div>
                        <div class="col-12 col-sm-9">
                            <div class="product-field-value">
                                {{$item->value}}
                            </div>
                        </div>
                    </div>
                    @else
                    <div class="row no-gutters product-field">
                        <h4>
                            <i class="icon-threeangle-right"></i>
                            {{$item->name}}
                        </h4>
                    </div>
                    @endif
                    @endforeach
                </div>
            </div>
            <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                @include('widget::comment.commentList',[
                'type'=>'product',
                'pageWidgetId'=>$product->id,
                'externalData' =>['comments' => $comments]
                ])


            </div>
        </div>

        @include('widget::rowProduct.productRow',['widget'=>(object)['general'=>(object)['title' => 'دیگر محصولات','container' => false]], 'params'=>$relatedProduct])

    </div>
</div>

<div class="modal fade" id="outOfStockNotifyModal" tabindex="-1" role="dialog" aria-labelledby="outOfStockNotifyModal" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body outOfStockNotifyModal">
                <div class="row justify-content-between">
                    <div>
                        به من اطلاع بده
                    </div>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="icon-close"></i>
                    </button>
                </div>

                <div class="row nt-content">
                    <div class="col-6 d-none d-md-flex align-items-center justify-content-center">
                        <i class="icon-alert"></i>
                    </div>
                    <div class="col-12 col-md-6 d-flex flex-column">
                        <div class="notify-title">اطلاع به من در زمان:</div>
                        <div class="notify-status">موجود شدن</div>
                        <hr>
                        <div class="notify-title"> از طریق:</div>
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="emailcheckBox" name="email">
                            <label class="custom-control-label" for="emailcheckBox">ایمیل به<span class="js-notify-stock-email"></span></label>
                        </div>
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="mobilecheckBox" name="mobile">
                            <label class="custom-control-label" for="mobilecheckBox">پیامک به <span class="js-notify-stock-mobile"></span></label>
                        </div>
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="notificationcheckBox" name="notification">
                            <label class="custom-control-label" for="notificationcheckBox">سیستم پیام شخصی گلدیران</label>
                        </div>
                        <button class="btn btn-danger js-submit-notify-button" type="submit" data-id="{{$product->id}}">ثبت</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="otherModelModal" tabindex="-1" role="dialog" aria-labelledby="outOfStockNotifyModal" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body outOfStockNotifyModal">
                <div class="row justify-content-between">
                    <div>
                        لیست مدل های مرتبط با این قطعه
                    </div>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="icon-close"></i>
                    </button>
                </div>

                <div class="row nt-content">
                    <div class="col-6 d-none d-md-flex align-items-center justify-content-center">
                        <i class="icon-filter"></i>
                    </div>
                    <div class="col-12 col-md-6 d-flex flex-column">
                        <p>با استفاده از ورودی پائین اطلاعات خود را فیلتر کنید.</p>
                        <input class="form-control" type="text" placeholder="جستجو ...">
                        <ul class="list-group">
                            @foreach($product->otherModel as $value)
                            <li class="list-group-item">{{$value->model}}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection