@section('content')
@var('gsPartBalance',$product->sync ? $product->getGSPrice() : $product->getFastGSPrice())
    @var('productDiscount',$product->discountPrice())
<div class="shop-body pt-3">
    <div class="container">
        @include('shop::index.breadcrumb')
        <div class="card">
            <div class="row">
                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 clear_xs dir-ltr pd_gallery_holder">
                    @include('shop::index.imageBox')
                </div>
                <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12 clear_xs pd_info_holder">
                    <div class="row">
                        <div class="col-9">
                            <div class="pd_info_content">
                                <h1>{{$product->name}}</h1>
                                <div class="brand-detail">
                                    <div>
                                        <span>برند: </span>
                                        <a href="#">{{@$product->brand->name}}</a>
                                    </div>
                                    <div>
                                        <span>دسته: </span>
                                        <a href="#">{{@$product->group->name}}</a>
                                    </div>
                                </div>
                                <div class="pd_info_evaluate">
                                    <div class="pd_info_rate">
                                        <span class="pd_info_rate_tag">
                                            <svg xmlns="http://www.w3.org/2000/svg" height="16px" viewBox="0 0 24 24" width="16px" fill="#fff">
                                                <path d="M0 0h24v24H0z" fill="none" />
                                                <path d="M0 0h24v24H0z" fill="none" />
                                                <path d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z" />
                                            </svg>
                                            <span class="pd_info_rate_num">4.7</span>
                                        </span>
                                        <span class="pd_info_rate_total">از
                                            12
                                            رای
                                        </span>
                                    </div>
                                    <div class="pd_info_comment">
                                        <svg xmlns="http://www.w3.org/2000/svg" height="16px" viewBox="0 0 24 24" width="16px" fill="#8c8c8c">
                                            <path d="M0 0h24v24H0z" fill="none" />
                                            <path d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM6 9h12v2H6V9zm8 5H6v-2h8v2zm4-6H6V6h12v2z" />
                                        </svg>
                                        <span class="pd_info_comment_total">(
                                            12
                                            نظر)
                                        </span>
                                    </div>
                                </div>
                                @if($product->warranty)
                                <div class="warranty-detail">
                                    <svg xmlns="http://www.w3.org/2000/svg" height="18px" viewBox="0 0 24 24" width="18px" fill="#8c8c8c">
                                        <path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm-2 16l-4-4 1.41-1.41L10 14.17l6.59-6.59L18 9l-8 8z"></path>
                                    </svg>
                                    <span>{{$product->warranty}} </span>
                                </div>
                                @endif
                                @include('shop::index.desktop.detail_icon')

                                @include('shop::index.desktop.price')

                                @if($product->otherModel->count())
                                <div class="model-container">
                                <div class="model-box">
                                            <div class="model-alert">
                                            قبل از خرید قطعه، از مرتبط بودن با مدل دستگاه خود مطمئن شوید
                                            </div>
                                    <div class="model-detail">
                                        <div class="mtitle">
                                            <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 0 24 24" width="24" fill="#999999">
                                                <path d="M7 5h2V3H7v2zm0 8h2v-2H7v2zm0 8h2v-2H7v2zm4-4h2v-2h-2v2zm0 4h2v-2h-2v2zm-8 0h2v-2H3v2zm0-4h2v-2H3v2zm0-4h2v-2H3v2zm0-4h2V7H3v2zm0-4h2V3H3v2zm8 8h2v-2h-2v2zm8 4h2v-2h-2v2zm0-4h2v-2h-2v2zm0 8h2v-2h-2v2zm0-12h2V7h-2v2zm-8 0h2V7h-2v2zm8-6v2h2V3h-2zm-8 2h2V3h-2v2zm4 16h2v-2h-2v2zm0-8h2v-2h-2v2zm0-8h2V3h-2v2z"></path>
                                            </svg>
                                            <span>مدل های تحت پوشش: </span>
                                        </div>
                                        <div class="mdetail">
                                            <button class="mbutton buttonColor" data-toggle="modal" data-target="otherModelModal">
                                                <span>مشاهده همه </span>
                                                <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#00c6db">
                                                    <path d="M15.41 16.59L10.83 12l4.58-4.59L14 6l-6 6 6 6 1.41-1.41z"></path>
                                                </svg>
                                            </button>
                                        </div>
                                    </div>
                                    </div>
                                </div>
                                @endif
                                @if((int)@$gsPartBalance['legalAvail'] > 0 && @$product->xstatus)
                                <button class="btn add-to-cart" type="submit" data-id="{{$product->id}}">
                                    <span> اضافه به سبد خرید </span>
                                    <i class="icon-wallet"></i>
                                </button>
                                @endif
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="pd_info_box">
                                <div class="pd_info_box_title">
                                    ارسال رایگان سفارش
                                </div>
                                <div class="pd_info_box_content">
                                    با خرید بالای 200 هزارتومان از ارسال رایگان بهره مند شوید.
                                </div>
                                <img class="pd_info_box_content_image" src="/eqlid/freeShiping.jpg" alt="">
                            </div>
                            @if(@$product->id == 1034)
                            <div class="pd_info_box">
                                <a href="https://cs.eqlid.ir/fa/blog/%DA%86%DA%AF%D9%88%D9%86%D9%87-%D9%81%DB%8C%D9%84%D8%AA%D8%B1-%DB%8C%D8%AE%DA%86%D8%A7%D9%84-%D8%A7%D8%B5%D9%84-%D8%B1%D8%A7-%D8%A7%D8%B2-%D8%AA%D9%82%D9%84%D8%A8%DB%8C-%D8%AA%D8%B4%D8%AE%DB%8C%D8%B5-%D8%AF%D9%87%DB%8C%D9%85%D8%9F">
                                <img src="/eqlid/adve2.gif" width="100%" alt="">
                                </a>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="product-suggest">
        @include('widget::amp-vert_product_list.desktop',['widget'=>(object)['general'=>(object)['title' => 'دیگر محصولات','container' => false]], 'params'=>$relatedProduct])
    </div>
    <div class="container">
        <div class="card">
            @include('shop::index.desktop.tab')
        </div>
    </div>

</div>
@include('shop::index.desktop.m_models')
@include('shop::index.desktop.m_outofstock')
@include('shop::index.desktop.m_images')
@endsection