<amp-state id="allSpec">
    <script type="application/json">
        {
            "items": [
            @foreach ($product->specifications()->where('xstatus',1)->get() as $item)
                {"name":"{{$item->name}}","value":"{{$item->value}}","selected":true}@if(!$loop->last),@endif
            @endforeach
            ]
        }
    </script>
</amp-state>

<div class="model-container">
    <div class="model-detail">
        <h5 class="secBox-title">مشخصات فنی</h5>
        <button class="mbutton buttonColor" on="tap:AMP.setState({showSpecLightbox: true})">
            <span>بیشتر</span>
            <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#00c6db">
                <path d="M15.41 16.59L10.83 12l4.58-4.59L14 6l-6 6 6 6 1.41-1.41z" />
            </svg>
        </button>
    </div>
    <div class="secBox-content">
        <div class="secBox-spec">
            <ul>
                    <amp-list  src="amp-state:allSpec" 
                                binding="no"
                                height = 2
                                width=200
                                layout="responsive"
                                class="alch"
                    >
                        <template type="amp-mustache">
                            @{{#selected}}
                            <li>
                                <span>@{{name}}: </span>
                                <span class="feature-value">@{{value}}</span>
                            </li>
                            @{{/selected}}
                        </template>   
                           
                    </amp-list>
                
            </ul>
        </div>
    </div>
</div>

<amp-lightbox id="spec-lightbox" [open]="showSpecLightbox" layout="nodisplay" on="lightboxClose:AMP.setState({showSpecLightbox: false})">
    <div class="lightbox lgtBox">
        <div class="lgtBox-header">
            <button class="mbutton" tabindex="0" type="button" aria-label="favorite" on="tap:spec-lightbox.close">
                <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" height="24px" viewBox="0 0 24 24" width="24px" fill="#999999"><path d="M15,5l-1.41,1.41L18.17,11H2V13h16.17l-4.59,4.59L15,19l7-7L15,5z"/></svg>
            </button>
            <div class="lgtBox-title">  مشخصات فنی کالا </div>
        </div>
        <div class="lgtBox-content">
            <div class="lgtBox-item">
                <div class="rs-container lightbox-container">    
                    
                    <amp-list  src="amp-state:allSpec" 
                                binding="no"
                                height = "2"
                                width=200
                                layout="responsive"
                                class="alch"
                    >
                        <template type="amp-mustache">
                            <div class="list-group-item d-flex justify-content-between">
                                <h3>@{{name}}</h3>
                                <span>@{{value}}</span>
                            </div>
                        </template>       
                    </amp-list>
</div>
                </div>
            </div>
            
        </div>
    </div>
</amp-lightbox>
