@section('content')
<div>
    <div class="">
        <div class="secondary-box">
            <div class="header-action">
                <button class="circleBtn " tabindex="0" type="button" aria-label="favorite">
                    <svg xmlns="http://www.w3.org/2000/svg" id="i-heart" width="22" height="22" viewBox="0 0 24 24" fill="currentColor">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.972 20.216l1.027-1.716 1.054 1.7a2 2 0 01-2.082.016zm-.48-13.709C9.719 5.982 8.709 5.5 7.607 5.5 5.082 5.5 3.6 7.357 4.094 9.906c.846 4.365 7.905 8.594 7.905 8.594l-1.027 1.716-.005-.003-.006-.004-.02-.012a10.43 10.43 0 01-.322-.201 32.586 32.586 0 01-3.556-2.637c-.998-.855-2.067-1.891-2.96-3.046-.879-1.138-1.678-2.508-1.973-4.026-.335-1.732-.033-3.46 1.025-4.787 1.065-1.335 2.687-2 4.452-2 1.824 0 3.34.859 4.28 1.545l.112.082.112-.082c.94-.686 2.457-1.545 4.28-1.545 3.945 0 6.221 3.655 5.46 6.867-.35 1.473-1.158 2.815-2.04 3.941-.893 1.142-1.949 2.174-2.931 3.028a33.846 33.846 0 01-3.797 2.845l-.02.013-.006.004-.004.002-1.054-1.7s6.88-4.264 7.906-8.594c.494-2.085-.988-4.406-3.514-4.406-1.1 0-2.11.482-2.884 1.007C12.585 7.134 12 7.821 12 7.821s-.585-.687-1.507-1.314z"></path>
                    </svg>
                </button>

                <amp-social-share type="system" aria-label="Share" width="28" height="28" class="shareAmp">
                    <button class="circleBtn " tabindex="0" type="button" aria-label="favorite">
                        <!-- <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16"><path d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z"></path></svg> -->
                        <svg xmlns="http://www.w3.org/2000/svg" height="22" viewBox="0 0 24 24" width="22" fill="currentColor">
                            <path d="M0 0h24v24H0z" fill="none" />
                            <path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z" />
                        </svg>
                    </button>
                </amp-social-share>
            </div>

            @include("shop::index.amp.carousel")
            @include("shop::index.amp.title")
        </div>

        <div class="secondary-box mt-2">
            <div class="rs-container">
                @include("shop::index.amp.model")
            </div>
        </div>

        <div class="secondary-box mt-2">
            <div class="rs-container">
                @include("shop::index.amp.specs")
            </div>
        </div>

        <div class="rs-container">
            @include('widget::amp-vert_product_list.index',[
            'widget'=>(object)['general'=>(object)['title' => 'دیگر محصولات','container' => false]],
            'params'=>$relatedProduct,
            'dontViewAll' => true,
            'container' => 'mt-2',
            ])
        </div>
        <div class="secondary-box mt-2">
            <div class="rs-container">
                @include("shop::index.amp.description")
            </div>
        </div>

        <div class="secondary-box mt-2">
            <div class="rs-container">
                @include("widget::amp-comment.vert_list",[
                'type'=>'product',
                'pageWidgetId'=>$product->id,
                'externalData' =>['comments' => $comments]
                ])
            </div>
        </div>

    </div>
</div>
@var('gsPartBalance',$product->sync ? $product->getGSPrice() : $product->getFastGSPrice())
@var('itemDiscount',$product->discountPrice())

<div class="add-to-cart-sticky">
    <amp-script layout="container" script="add-to-cart-script" data-ampdevmode>
        <a class="add-to-cart">افزودن به سبد خرید</a>
    </amp-script>
    <script id="add-to-cart-script" type="text/plain" target="amp-script">
        const addToCart = document.getElementsByClassName('add-to-cart')[0];
        function convertDigit(num){
            num = String(num);
            num = (num).replace(/0/g, '۰');
            num = (num).replace(/1/g, '۱');
            num = (num).replace(/2/g, '۲');
            num = (num).replace(/3/g, '۳');
            num = (num).replace(/4/g, '۴');
            num = (num).replace(/5/g, '۵');
            num = (num).replace(/6/g, '۶');
            num = (num).replace(/7/g, '۷');
            num = (num).replace(/8/g, '۸');
            num = (num).replace(/9/g, '۹');
            return num;
        }
        addToCart.addEventListener('click',function(){
            var data = {
                id: {{$product->id}},
                type: 'product'
            }
            var xmlhttp = new XMLHttpRequest();
            xmlhttp.onreadystatechange = function () {
                if (xmlhttp.readyState === XMLHttpRequest.DONE) {
                    var status = xmlhttp.status;
                    if (status === 0 || (status >= 200 && status < 400)) {
                        var count = convertDigit(JSON.parse(xmlhttp.responseText).count);
                        AMP.setState({basketCount: count});
                    } else {
                        alert('خطا در ارسال اطلاعات');
                    }
                }
            }
            xmlhttp.open("POST", 'https://cs.eqlid.ir/Cart/store', true);
            xmlhttp.setRequestHeader('X-CSRF-TOKEN', "{{ csrf_token() }}");
            xmlhttp.setRequestHeader('Content-type', 'application/json');
            xmlhttp.send(JSON.stringify(data));
        }); 

    </script>
    <div class="">
        @if((int)$gsPartBalance['legalAvail'] > 0)
        @if($itemDiscount && $itemDiscount['price'])
        <div class="text-left">
            <div class="o-price_old">
                <del>{{FarsiLib::convertDigit(number_format($gsPartBalance['customerPrice']))}}</del>
                <div class="o-price_discount">{{FarsiLib::convertDigit(round($itemDiscount['price']*100/$gsPartBalance['customerPrice']))}}%</div>
            </div>
            <div class="o-price_value">
                <span>{{FarsiLib::convertDigit(number_format($gsPartBalance['customerPrice'] - $itemDiscount['price']))}}</span>
                <span class="o-price_currency">تومان</span>
            </div>
        </div>
        @else
        @if($gsPartBalance['customerPrice'])
        <span>{{FarsiLib::convertDigit(number_format($gsPartBalance['customerPrice']))}} <span class="Price-currencySymbol">تومان</span> </span>
        @else
        <span>رایگان</span>
        @endif
        @endif
        @else
        <span>نا موجود</span>
        @endif
    </div>
</div>

@endsection