import $ from 'jquery'
import 'slick-carousel'
import Swiper from 'swiper';

$(document).ready(function(){
			initialShopProductRow();
			if($('.sidebar-filter select.modelList').length)
				$('.sidebar-filter select.modelList').selectize({
					onFocus : function (){
						let $activeSelect = $('.sidebar-filter select.modelList')[0].selectize;
						let $value = $activeSelect.getValue();
						if ($value.length > 0) {
							$activeSelect.clear( true);
						}
				}
				});

			$('.slider').slick({
				slidesToShow: 1,
				slidesToScroll: 1,
				arrows: false,
				fade: false,
				asNavFor: '.slider-nav-thumbnails',
			});
		 
			$('.slider-nav-thumbnails').slick({
				slidesToShow: 5,
				slidesToScroll: 1,
				asNavFor: '.slider',
				dots: true,
				focusOnSelect: true
			});
		 
			//remove active class from all thumbnail slides
			$('.slider-nav-thumbnails .slick-slide').removeClass('slick-active');
		 
			//set active class to first thumbnail slides
			$('.slider-nav-thumbnails .slick-slide').eq(0).addClass('slick-active');
		 
			// On before slide change match active thumbnail to current slide
			$('.slider').on('beforeChange', function (event, slick, currentSlide, nextSlide) {
				var mySlideNumber = nextSlide;
				$('.slider-nav-thumbnails .slick-slide').removeClass('slick-active');
				$('.slider-nav-thumbnails .slick-slide').eq(mySlideNumber).addClass('slick-active');
		 	});

		 $(document).on('click','.js-more-otherModel-button',function(event){
			$('#otherModelModal').modal('show');
		 });

		$("#otherModelModal input").on("keyup", function() {
			var value = $(this).val().toLowerCase();
			$("#otherModelModal .list-group li").filter(function() {
			  $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
			});
		});

		 $(document).on('click','.js-product-add-favorite',function(event){
			const id = $(event.currentTarget).data("id")
			let thisElement = $(event.currentTarget)
			event.preventDefault();
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				type: 'POST',
				url: '/Profile/updateFavorite',
				data: {id:id},
	
				error: function(xhr, ajaxOptions, thrownError){
					
					if(xhr.status == 401){
						$('#loginModal').modal('show');
						return;
					}
					else
						alert(xhr.responseJSON.message);
				},
				
				success: function (data) {
					thisElement.toggleClass('active');
				}
			});
			
		});
		 
});

export function initialShopProductRow(){

	let bookSwiperOption= {
		// Optional parameters
	    //direction: 'vertical',
	    //freeMode: true,
	    //grabCursor: true,
	    //slidesPerGroup: 3,
      	//loopFillGroupWithBlank: true,
	    slidesPerView: 5,
	    spaceBetween: 0,

	    loop: false,
	    speed: 400,
	    

	    breakpoints: {
	        1200: {
	          slidesPerView: 5,
	        },
	        992: {
	          slidesPerView: 4,

	        },
	        768: {
	          slidesPerView: 3,
	        },
	        480: {
	          slidesPerView: 2,
	        },
	        320: {
	          slidesPerView: 1,
	        }
	    },

	    // If we need pagination
	    pagination: {
	      el: '.product-row-carousel .swiper-pagination',
	      dynamicBullets: false
	    },

	    // Navigation arrows
	    navigation: {
	      nextEl: '.product-row-wrapper .swiper-button-next',
	      prevEl: '.product-row-wrapper .swiper-button-prev',
	    }
	}
	
	let myBookSwiper = []
	$('.product-row-carousel').each(function(){
		let newElm = '.brc-'+$(this).data('module');
		let temp = bookSwiperOption;
		temp.pagination.el = newElm + ' .product-row-carousel' + ' .swiper-pagination'
		temp.navigation.nextEl = newElm + ' .swiper-button-next'
		temp.navigation.prevEl = newElm + ' .swiper-button-prev'
		myBookSwiper.push(new Swiper(newElm + ' .product-row-carousel', temp));
    })
}