document.addEventListener("DOMContentLoaded", function (event) {
    var swiper = new Swiper('.swiper-plans', {
        // Optional parameters
        loop: true,
        autoplay: {
            delay: 8000
        },
        // If we need pagination
        pagination: {
            el: '.swiper-plans .swiper-pagination',
        },

        // Navigation arrows
        navigation: {
            nextEl: '.swiper-plans .swiper-button-next',
            prevEl: '.swiper-plans .swiper-button-prev',
        }
    });

    var stickyElm = document.querySelector('.add-to-cart-sticky');
    var stickyElmTop = stickyElm.offsetTop;
    var header = document.querySelector('.f-wrapper');
    var sticky = header.offsetTop;
    
    window.onscroll = function () {
        if (window.pageYOffset + window.innerHeight /2 > sticky  && window.pageYOffset + window.innerHeight < (stickyElmTop)) {
            stickyElm.classList.add("fixed");
        } else {
            stickyElm.classList.remove("fixed");
        }
    };

    var openBtn = document.querySelectorAll('[data-toggle = "modal"]');
    var closeBtn = document.querySelectorAll('[data-dismiss = "modal"]');

    openBtn.forEach(item => {
        item.addEventListener('click', function (event) {
            var modal = document.getElementById(event.currentTarget.getAttribute('data-target'));
            modal.classList.add("show");
            modal.setAttribute('aria-hidden', 'false');
            var eventShow = new CustomEvent('modal-show', {
                bubbles: true,
                detail: {
                    relatedTarget: event.currentTarget
                }
            })
            modal.dispatchEvent(eventShow);
        });
    });

    closeBtn.forEach(item => {
        item.addEventListener('click', function (event) {
            var modal = document.getElementById(event.currentTarget.getAttribute('data-target'));
            modal.setAttribute('aria-hidden', 'true');
            new Promise(resolve => setTimeout(resolve, 290)).then(() => {
                modal.classList.remove("show");
            });
            var eventClose = new Event('modal-close');
            modal.dispatchEvent(eventClose);
        });
    });

    Warranty.init();
});

var Warranty = {
    pFinalPrice: '.final-price-box .final-price',
    pPrice: '.price-box .price',
    pProfit: '.profit-price-box .profit-price',

    tPrice: '.total-final-price-box .final-price',
    tProfit: '.total-profit-price-box .profit-price',

    multiNumber: '.multi-device-discount .number',
    multiPercent: '.multi-device-discount .percent .percent-cont',

    init: function () {
        this.yearBtnEvent();
        this.checkboxProductEvent();
        this.dispatchPriceChange();
        this.faqToggle();
        this.payment();
    },
    payment: function(){
        var btn = document.querySelector('.inc-balance__box.pay-box');
        
        btn.addEventListener("click",(event) => {
            var node = event.currentTarget;
            var form = document.createElement("form");
            var element1 = document.createElement("input"); 
            var element2 = document.createElement("input");  
            var element3 = document.createElement("input");  
        
            form.method = "POST";
            form.action = "/payment/servicePayment";   
        
            element1.value=document.querySelector('#mobile').value;
            element1.name="mobile";
            element1.type="hidden";
            form.appendChild(element1);
        
            element2.value=JSON.stringify(state);
            element2.name="state";
            element2.type="hidden";
            form.appendChild(element2);

            element3.value=document.querySelector('meta[name="csrf-token"]').content;
            element3.name="_token";
            element3.type="hidden";
            form.appendChild(element3);
        
            document.body.appendChild(form);
            form.submit();
        })
    },
    faqToggle: function () {
        var faqBtn = document.querySelectorAll('.w-dropdown');
        for (var i = 0; i < faqBtn.length; i++) {
            faqBtn[i].addEventListener("click", (event) => {
                var node = event.currentTarget;
                for (var j = 0; j < node.children.length; j++) {
                    node.children[j].classList.toggle('w--open');
                }

            })
        }

    },
    yearBtnEvent: function () {
        var yearSelectBtn = document.querySelectorAll('.year-btn');
        for (var i = 0; i < yearSelectBtn.length; i++) {
            yearSelectBtn[i].addEventListener("click", (event) => {
                var node = event.currentTarget;
                var productId = node.getAttribute('data-product');
                var yearId = node.getAttribute('data-id');
                var siblings = event.currentTarget.parentNode.querySelectorAll('.active');
                for (var j = 0; j < siblings.length; j++) {
                    siblings[j].classList.remove('active');
                }
                node.classList.toggle('active');
                this.setYearState(yearId, productId);
                this.dispatchPrice(yearId, productId);
            })
        }
    },
    setYearState: function (id, pid) {
        state[pid].durationType = id;
    },
    dispatchPrice: function (id, pid) {
        var plan = state[pid].planType == 1 ? 'g' : 'd';
        var priceTitle = plan + 'PriceYear' + id;
        var price = Math.round(parseInt(products[pid][priceTitle]) / 10);

        var pPriceElm = document.querySelector('div[data-productbox="' + pid + '"] ' + this.pPrice);
        var pFinalPriceElm = document.querySelector('div[data-productbox="' + pid + '"] ' + this.pFinalPrice);
        var pProfitElm = document.querySelector('div[data-productbox="' + pid + '"] ' + this.pProfit);
        var pProfitBox = document.querySelector('div[data-productbox="' + pid + '"] ' + '.profit-price-box');
        var pPriceBox = document.querySelector('div[data-productbox="' + pid + '"] ' + '.price-box');

        switch (parseInt(id)) {
            case 1:
                pFinalPriceElm.innerHTML = this.addCommasNumber(price);
                pPriceBox.classList.add('d-none');
                pProfitBox.classList.add('d-none');
                break;

            case 2:
                pPriceElm.innerHTML = this.addCommasNumber(Math.round(price * 1.15));
                pFinalPriceElm.innerHTML = this.addCommasNumber(price);
                pProfitElm.innerHTML = this.addCommasNumber(Math.round(price * 0.15));

                pPriceBox.classList.remove('d-none');
                pProfitBox.classList.remove('d-none');
                break;

            case 3:
                pPriceElm.innerHTML = this.addCommasNumber(Math.round(price * 1.20));
                pFinalPriceElm.innerHTML = this.addCommasNumber(price);
                pProfitElm.innerHTML = this.addCommasNumber(Math.round(price * 0.20));

                pPriceBox.classList.remove('d-none');
                pProfitBox.classList.remove('d-none');
                break;

            case 4:
            case 5:
                pPriceElm.innerHTML = this.addCommasNumber(Math.round(price * 1.25));
                pFinalPriceElm.innerHTML = this.addCommasNumber(price);
                pProfitElm.innerHTML = this.addCommasNumber(Math.round(price * 0.25));

                pPriceBox.classList.remove('d-none');
                pProfitBox.classList.remove('d-none');
                break;
            default:
                break;
        };

        this.dispatchPriceChange();
    },
    setTotalPrice: function () {
        var totalProfit = 0,
            totalMultiDeviceDiscount = 0,
            totalSeveralYear = 0,
            totalPrice = 0,
            totalIncreaseYear = 0,
            multipleDeviceSelected = 0;

        for (var pid = 0; pid < state.length; pid++) {
            if (state[pid].checked) {
                multipleDeviceSelected++;
            }
        }
        for (var pid = 0; pid < state.length; pid++) {
            if (state[pid].checked) {
                var plan = state[pid].planType == 1 ? 'g' : 'd';
                var priceTitle = plan + 'PriceYear' + state[pid].durationType;
                var price = Math.round(parseInt(products[pid][priceTitle]) / 10);
                var multiDeviceTitle = 'multiProductDiscount' + multipleDeviceSelected;

                var percent = this.getProfitPercent(state[pid].durationType);
                totalIncreaseYear += (price * (1 + percent))
                totalProfit += (price * percent);
                totalSeveralYear += (products[pid].severalYearsDiscount * price);
                totalPrice += price;
                totalMultiDeviceDiscount += (price * products[pid][multiDeviceTitle]);
            }
        }

        var tPriceElm = document.querySelector(this.tPrice);
        var tProfitElm = document.querySelector(this.tProfit);

        var totalFinal = totalPrice  - totalMultiDeviceDiscount - totalSeveralYear;
        var totalDiscount = totalProfit + totalMultiDeviceDiscount + totalSeveralYear;
        var totalFinalWithTax = Math.ceil((totalFinal * 1.09) / 500) * 500;

        tPriceElm.innerHTML = this.addCommasNumber(Math.round(totalFinal));
        tProfitElm.innerHTML = this.addCommasNumber(Math.round(totalDiscount));

        var multiNumberElm = document.querySelector(this.multiNumber);
        var multiPercentElm = document.querySelector(this.multiPercent);
        multiNumberElm.innerHTML = Math.round(multipleDeviceSelected);
        multiPercentElm.innerHTML = '%' + Math.round((totalMultiDeviceDiscount / totalPrice) * 100);

        this.setModalPrices(totalIncreaseYear, totalFinal * 0.09, totalMultiDeviceDiscount, totalSeveralYear, totalProfit, totalFinalWithTax);
        this.setModalDevices();

    },
    setModalPrices: function (total, tax, discountMulti, discountSeveral, discountYear, totalFinal) {
        var mTotal = document.querySelector('.m-invoice .m-total'); //جمع کل
        var mTotalTax = document.querySelector('.m-invoice .m-tax'); // مالیات
        var mDiscountMultiDevice = document.querySelector('.m-invoice .m-discount-multi-device'); //تخفیف چند دستگاهی
        var mDiscountSeveral = document.querySelector('.m-invoice .m-discount-several'); //تخفیف ویژه تمدید دوباره
        var mTotalDiscount = document.querySelector('.m-invoice .m-discount-multi-year'); //جمع کل تخفیف
        var mTotalFinal = document.querySelector('.m-invoice .m-total-final'); //مبلغ قابل پرداخت

        mTotal.innerHTML = this.addCommasNumber(Math.round(total));
        mTotalTax.innerHTML = this.addCommasNumber(Math.round(tax));
        mDiscountMultiDevice.innerHTML = this.addCommasNumber(Math.round(discountMulti));
        mDiscountSeveral.innerHTML = this.addCommasNumber(Math.round(discountSeveral));
        mTotalDiscount.innerHTML = this.addCommasNumber(Math.round(discountYear));
        mTotalFinal.innerHTML = this.addCommasNumber(Math.round(totalFinal));
    },
    setModalDevices: function () {
        var template = `
          <div class="d-flex">
              <div class="title cell">{name}</div>
              <div class="model cell">مدل {model}</div>
          </div>
          <div class="duration cell">{duration}</div>
        `;

        var board = document.querySelector('.m-devices');
        board.innerHTML = "";
        for (var pid = 0; pid < state.length; pid++) {
            if (state[pid].checked) {
              var div = document.createElement('div');
              div.className = 'device-item';
              div.innerHTML = template.trim().replace(/{(\w*)}/g,function( m, key ){
                var t= "";
                if(key == 'duration'){
                  t = state[pid].durationType == 1 ? 'یکساله' : state[pid].durationType == 2 ? 'دوساله' : state[pid].durationType == 3 ? 'سه ساله' : 'چهار ساله';
                }
                return state[pid].hasOwnProperty( key ) ? state[pid][ key ] : t;
              });
              board.appendChild(div);
            }
        }
    },
    getProfitPercent: function (num) {
        switch (parseInt(num)) {
            case 1:
                return 0;
            case 2:
                return 0.15;
            case 3:
                return 0.20;
            case 4:
            case 5:
                return 0.25;
            default:
                return 0;
        }
    },
    checkboxProductEvent: function () {
        var deviceSelectBtn = document.querySelectorAll('.f-option-button');
        for (var i = 0; i < deviceSelectBtn.length; i++) {
            deviceSelectBtn[i].addEventListener("click", (event) => {
                var parent = event.currentTarget.parentNode;
                parent.classList.toggle('active');
                var productId = event.currentTarget.getAttribute('data-product');
                this.setSelectState(productId, parent.classList.contains('active'));
                this.dispatchPriceChange();
            })
        }
    },
    setSelectState: function (pid, value) {
        state[pid].checked = value;
    },
    dispatchPriceChange: function (pid) {
        this.setTotalPrice();
    },

    addCommasNumber: function (nStr) {
        nStr += '';
        const x = nStr.split('.');
        let x1 = x[0];
        let x2 = x.length > 1 ? '.' + x[1] : '';
        let rgx = /(\d+)(\d{3})/;
        while (rgx.test(x1)) {
            x1 = x1.replace(rgx, '$1' + ',' + '$2');
        }
        return x1 + x2;
    },
}
