@section('content')
<div class="blog-body">
    <div class="blog-banner-holder">
        <img src="/source/material/jobbg.png">
        <div class="container">
            <div class="row align-items-center hero-wrap justify-content-between mt-5 mb-5">
                <div class="col-12 col-md-6 ">
                    <div class="wrapper">
                        <div class=" m-auto">
                            <h1> @t('site name')</h1>
                            <p class="text-justify">
                               @t('job detail description')
                            </p>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<div class="job-detail">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-8">
                <div class="job-detail-content">
                    <h1>{{$job->name}}</h1>
                    <hr>
                    {!!$job->description!!}
                </div>
            </div>
            <div class="col-12 col-md-4">
                @if (session('status'))
                    <div class="alert alert-success">
                        {{ session('status') }}
                    </div>
                @else
                <div class="job-register">
                    <h2>@t('submit your resume')</h2>
                    <hr>
                    <form action="/jobs/sendResume" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="id" value="{{$job->id}}">
                        <input type="text" name="name" value="" placeholder="@t('name')  ">
                        <input type="text" name="mobile" value="" placeholder="@t('mobile') ">
                        <input type="text" name="email" value="" placeholder="@t('email') ">
                        
                        <div class="custom-file mb-2">
                            <input name="resumeFile" type="file" class="custom-file-input" id="customFile">
                            <label class="custom-upload-label" for="customFile" id="resume-file-label">@t('upload resume file')</label>
                        </div>
                        <div class="d-flex">
                                {!! captcha_img('flat') !!}
                                <input name="captcha" maxlength="8" maxlength="5" type="text" value="{{ old('captcha') }}" placeholder="@t('secure code')" required />
                        </div>
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <input type="submit" value=" @t('send')" class="btn btn-danger">
                    </form>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection