@section('content')
<div class="request-body">
    <div class="blog-banner-holder">
        <div class="container">
            <div class="row align-items-center hero-wrap justify-content-between">
                <div class="col-12 col-md-5 pl-0 pr-0 heroImg order-first">
                    <img itemprop="image" src="/eqlid/material/request.png" alt="Hero Image" width="950" height="870" class="img-fluid">
                </div>
                <div class="col-12 col-md-6 pl-0 pr-0 heroTxt">
                    <div class="wrapper">
                        <div class=" m-auto">
                            <h1> درخواست خود را در سریعترین زمان ثبت کنید</h1>
                            <p>
                                کافیه چند ثانیه ای وقت بگذارید و درخواستتون را در سیستم ثبت کنید. کارشناسان ما در سریعترین زمان ممکن با شما تماس خواهند گرفت.
                            </p>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<div class="wrapper">
    <div class="main">
        <div class="contact-content">
            <div class="container">
                <div class="row justify-content-between ">

                    <div class="col-12 mt-3">

                        <form role="form" id="contact-form" method="post" action="/inquiry/sendForm">
                            @if (count($errors) > 0)
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                            @endif
                            @if(Session::get('success'))
                            <div class="alert alert-success">
                                <button class="close" data-close="alert"></button>
                                <span>{!! Session::get('success') !!}</span>
                            </div>
                            @endif
                            <input type="hidden" class="field" name="_token" value="{{ csrf_token()}}">
                            <h4 class="mt-3"> اطلاعات پایه </h4>
                            <div class="row">
                                <div class="col-4">
                                    <div class="custom-control custom-radio js-radio-div mt-2 mb-4">
                                        <input type="radio" id="customRadio0" name="info[personalType]" class="custom-control-input js-personal-type" data-id="1" value="0" checked="checked">
                                        <label class="custom-control-label" for="customRadio0">حقیقی</label>
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="custom-control custom-radio js-radio-div mt-2 mb-4">
                                        <input type="radio" id="customRadio1" name="info[personalType]" class="custom-control-input js-personal-type"  value="2" data-id="2">
                                        <label class="custom-control-label" for="customRadio1">حقوقی</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row js-personal">

                                <div class="col-12 col-md-3 mb-3">
                                    <input name="info[p-fname]" type="text" class="form-control js-fname-input" placeholder="نام" data-valid="only-text" value="{{@$user->userInfo->xname}}">
                                    <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                </div>
                                <div class="col-12 col-md-3 mb-3">
                                    <input name="info[p-lname]" type="text" class="form-control js-lname-input" placeholder="نام خانوادگی" data-valid="only-text" value="{{@$user->userInfo->xfamily}}">
                                    <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                </div>
                                <div class="col-12 col-md-3 mb-3">
                                    <input name="info[p-mobile]" type="text" min="11" max="11" class="form-control js-mobile-input" placeholder="تلفن همراه " data-valid="only-number" value="{{@$user->userInfo->xmobile}}">
                                    <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل اعداد مانند 09123456789</div>
                                </div>
                                <div class="col-12 col-md-3 mb-3">
                                    <input name="info[p-email]" type="text" min="11" max="11" class="form-control js-mobile-input" placeholder=" ایمیل " data-valid="only-number" value="{{@$user->userInfo->email}}">
                                    <div class="error c-ui-feedback-hint">فیلد الزامی مانند info@eqlidplus.ir</div>
                                </div>

                            </div>
                            <div class="row js-company d-none">

                                <div class="col-12 col-md-4 mb-3">
                                    <input name="info[c-company]" type="text" class="form-control js-fname-input" placeholder="نام شرکت / مجموعه" data-valid="only-text">
                                    <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                </div>
                                <div class="col-12 col-md-4 mb-3">
                                    <input name="info[c-manager]" type="text" class="form-control js-lname-input" placeholder="نام مدیرعامل" data-valid="only-text">
                                    <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                </div>
                                <div class="col-12 col-md-4 mb-3">
                                    <input name="info[c-activityType]" type="text" class="form-control js-lname-input" placeholder="نوع فعالیت" data-valid="only-text">
                                    <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                </div>
                                <div class="col-12 col-md-6 mb-3">
                                    <input name="info[c-mobile]" type="text" min="11" max="11" class="form-control js-mobile-input" placeholder="تلفن همراه " data-valid="only-number" value="{{@$user->userInfo->xmobile}}">
                                    <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل اعداد مانند 09123456789</div>
                                </div>
                                <div class="col-12 col-md-6 mb-3">
                                    <input name="info[c-email]" type="text" min="11" max="11" class="form-control js-mobile-input" placeholder=" ایمیل " data-valid="only-number" value="{{@$user->userInfo->email}}">
                                    <div class="error c-ui-feedback-hint">فیلد الزامی مانند info@eqlidplus.ir</div>
                                </div>

                            </div>

                            <div class="new-requests">
                            <div class="new-request-row select-chain-row">

                                <h4 class="mt-3"> نوع سفارش </h4>
                                <div class="row">
                                    <div class="col-12 col-md-4 mb-3">
                                        <select name="r[row1][svctypeid]" class="form-control inqueryTypeSelect">
                                            <option value="0" disabled selected>نوع درخواست</option>
                                            <option value="1">انبارش</option>
                                            <option value="2">توزیع سراسری</option>
                                            <option value="3"> حمل و نقل سبک درون شهری</option>
                                            <option value="4"> توزیع مویرگی</option>
                                            <option value="5"> مشاوره خدمات لجستیکی</option>
                                        </select>
                                        <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                    </div>
                                </div>
                                <div class="js-warehouse row d-none">
                                    <div class="col-12 col-md-4 mb-3 mb-3">

                                        <select name="r[row1][meter]"  class="form-control " placeholder="متراژ">
                                            <option value="0" disabled selected>متراژ</option>
                                            @foreach($Meter as $value)
                                                <option value="$value['id']">{{$value['name']}}</option>
                                            @endforeach
                                        </select>

                                        <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                    </div>
                                    <div class="col-12 col-md-4 mb-3">
                                        
                                        <select name="r[row1][warehouseType]"  class="form-control " placeholder="نوع انبار">
                                            <option value="0" disabled selected>نوع انبار</option>
                                            @foreach($Warehousetype as $value)
                                                <option value="$value['id']">{{$value['name']}}</option>
                                            @endforeach
                                        </select>

                                        <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                    </div>
                                    <div class="col-12 col-md-4 mb-3">
                                        <select name="r[row1][itemType]"  class="form-control " placeholder="نوع کالا">
                                            <option value="0" disabled selected>نوع کالا</option>
                                            @foreach($Itemtype as $value)
                                                <option value="$value['id']">{{$value['name']}}</option>
                                            @endforeach
                                        </select>
                                        <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                    </div>
                                    <div class="col-12 col-md-4 mb-3">
                                        
                                        <select name="r[row1][count]"  class="form-control " placeholder=" مدت زمان">
                                            <option value="0" disabled selected>مدت زمان </option>
                                            @foreach($Duration as $value)
                                                <option value="{{$value['id']}}">{{$value['name']}}</option>
                                            @endforeach
                                        </select>

                                        <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                    </div>
                                    <div class="col-12 col-md-4 mb-3">
                                        <select name="r[row1][toProvince]"  class="form-control ">
                                            <option value="0" disabled selected>شهر های دارای انبار </option>
                                            @foreach($fullProvinceList as $value)
                                                @if($value['warehouse'])
                                                    <option value="{{$value['id']}}">{{$value['name']}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                        <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                    </div>
                                    <div class="col-12 mt-3 mb-3">
                                        <textarea name="r[row1][description]" rows="2" class="form-control js-remark-input" placeholder="توضیحات"></textarea>
                                    </div>
                                </div>
                                <div class="js-extraction row d-none">
                                    <div class="col-12 col-md-4 mb-3 mb-3">
                                    <select name="r[row1][fromProvince]"  class="form-control ">
                                            <option value="0" disabled selected>مبدا</option>
                                            @foreach($fullProvinceList as $value)
                                                @if($value['source'])
                                                    <option value="{{$value['id']}}">{{$value['name']}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                        <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                    </div>
                                    <div class="col-12 col-md-4 mb-3">
                                        <select name="r[row1][transferType]"  class="form-control ">
                                            <option value="0" disabled selected>نوع وسیله</option>
                                            @foreach($Transfertype as $value)
                                                    <option value="{{$value['id']}}">{{$value['name']}}</option>
                                            @endforeach
                                        </select>
                                        <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                    </div>
                                    <div class="col-12 col-md-4 mb-3">
                                        <select name="r[row1][itemType]"  class="form-control ">
                                            <option value="0" disabled selected>نوع کالا</option>
                                            @foreach($Itemtype as $value)
                                                    <option value="{{$value['id']}}">{{$value['name']}}</option>
                                            @endforeach
                                        </select>
                                        <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                    </div>
                                    <div class="col-12 col-md-4 mb-3">
                                        <select name="r[row1][count]"  class="form-control ">
                                            <option value="0" disabled selected>تعداد ماهیانه</option>
                                            @foreach($Countpermonth as $value)
                                                    <option value="{{$value['id']}}">{{$value['name']}}</option>
                                            @endforeach
                                        </select>
                                        <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                    </div>
                                    <div class="col-12 col-md-4 mb-3">
                                        <select name="r[row1][toProvince]"  class="form-control ">
                                            <option value="0" disabled selected>شهر های دارای خدمت </option>
                                            @foreach($fullProvinceList as $value)
                                                @if($value['service'])
                                                    <option value="{{$value['id']}}">{{$value['name']}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                        <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                    </div>
                                    <div class="col-12 mt-3 mb-3">
                                        <textarea name="r[row1][description]" rows="2" class="form-control js-remark-input" placeholder="توضیحات"></textarea>
                                    </div>
                                </div>
                                <div class="js-logestic row d-none">
                                    <div class="col-12 col-md-4 mb-3 mb-3">
                                        <select name="r[row1][fromProvince]"  class="form-control ">
                                            <option value="0" disabled selected>مبدا</option>
                                            @foreach($fullProvinceList as $value)
                                                @if($value['source'])
                                                    <option value="{{$value['id']}}">{{$value['name']}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                        <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                    </div>
                                    <div class="col-12 col-md-4 mb-3">
                                        <select name="r[row1][transferType]"  class="form-control ">
                                            <option value="0" disabled selected>نوع وسیله</option>
                                            @foreach($Transfertype as $value)
                                                    <option value="{{$value['id']}}">{{$value['name']}}</option>
                                            @endforeach
                                        </select>
                                        <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                    </div>
                                    <div class="col-12 col-md-4 mb-3">
                                        <select name="r[row1][itemType]"  class="form-control ">
                                            <option value="0" disabled selected>نوع کالا</option>
                                            @foreach($Itemtype as $value)
                                                    <option value="{{$value['id']}}">{{$value['name']}}</option>
                                            @endforeach
                                        </select>
                                        <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                    </div>
                                    <div class="col-12 col-md-4 mb-3">
                                        <select name="r[row1][count]"  class="form-control ">
                                            <option value="0" disabled selected>تعداد روزانه</option>
                                            @foreach($Countpermonth as $value)
                                                    <option value="{{$value['id']}}">{{$value['name']}}</option>
                                            @endforeach
                                        </select>
                                        <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                    </div>
                                    <div class="col-12 col-md-4 mb-3">
                                    <select name="r[row1][toProvince]"  class="form-control ">
                                            <option value="0" disabled selected>شهرهای دارای خدمت</option>
                                            @foreach($fullProvinceList as $value)
                                                @if($value['service'])
                                                    <option value="{{$value['id']}}">{{$value['name']}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                        <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                    </div>
                                    <div class="col-12 mt-3 mb-3">
                                        <textarea name="r[row1][description]" rows="2" class="form-control js-remark-input" placeholder="توضیحات"></textarea>
                                    </div>
                                </div>
                                <div class="js-agent row d-none">
                                    <div class="col-12 col-md-4 mb-3 mb-3">
                                        <select name="r[row1][consultingType]"  class="form-control ">
                                            <option value="0" disabled selected>نوع مشاوره </option>
                                            @foreach($Consultingtype as $value)
                                                    <option value="{{$value['id']}}">{{$value['name']}}</option>
                                            @endforeach
                                        </select>
                                        <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                                    </div>

                                    <div class="col-12 col-md-4 mb-3">
                                        <select name="r[row1][toProvince]"  class="form-control ">
                                            <option value="0" disabled selected>شهر درخواست خدمت</option>
                                            @foreach($fullProvinceList as $value)
                                                @if($value['service'])
                                                    <option value="{{$value['id']}}">{{$value['name']}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                        <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                    </div>
                                    <div class="col-12 mt-3 mb-3">
                                        <textarea name="r[row1][description]" rows="2" class="form-control js-remark-input" placeholder="توضیحات"></textarea>
                                    </div>
                                </div>
                                <div class=" new-request-btn-style new-request-plus">
                                    <i class="icon-plus"></i>
                                </div>
                            </div>
                            </div>

                            <h4 class="mt-3"> مشخصات آدرس </h4>
                            <div class="row">
                                <div class="col-12 col-md-3 mb-3">
                                    {!! Form::select('info[provinceId]', @$provinceList, @$address->xprovinceid ?? 0, ['class' => 'form-control ', 'id' => 'provinceListCombo' , 'data-valid'=>'only-number']) !!}
                                </div>
                                <div class="col-12 col-md-3 mb-3">
                                    {!! Form::select('info[cityId]', [@$address->xcityid ?? 0 => ' شهر'], @$address->xcityid ?? 0, ['class' => 'form-control ', 'id' => 'cityListCombo', 'data-valid'=>'only-number']) !!}
                                </div>
                                <div class="col-12 col-md-3 mb-3">
                                    {!! Form::select('info[regionId]', [$address->xregionid ?? 0=> ' منطقه'], @$address->xregionid ?? 0, ['class' => 'form-control productList', 'id' => 'regionListCombo', 'data-valid'=>'only-number']) !!}
                                    <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                </div>
                                <div class="col-12 col-md-3 mb-3">
                                    {!! Form::select('info[parishId]', [$address->xparishid ?? 0 => ' محله'], $address->xparishid ?? 0, ['class' => 'form-control productList', 'id' => 'parishListCombo', 'data-valid'=>'only-number']) !!}
                                    <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                </div>
                                <div class="col-12 mt-3 mb-3">
                                    <input name="info[address]" type="text" class="form-control js-adddress-input" placeholder="آدرس" data-valid="text" value="{{@$address->xaddress_content}}">
                                    <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                </div>

                            </div>
                            <div class="comment-action row mb-5">
                                <div class="col-12 d-flex">
                                    {!! captcha_img('flat') !!}
                                    <div id="reCaptcha"><i class="icon-refresh"></i></div>
                                    <input class="ml-1 mr-1" name="captcha" maxlength="8" type="text" value="{{ old('captcha') }}" placeholder="@t('Secure Code')" required>
                                    <input type="submit" class="btn ml-1 mr-1" value="@t('send')">
                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>

</div>
<script type="text/javascript">
    var cityList = {!! json_encode($cityList) !!};
    var regionList = {!! json_encode($regionList) !!};
    var parishList = {!! json_encode($parishList) !!};

</script>
@endsection