@section('content')
    <div class="blog-body">
        <div class="blog-banner-holder">
            <img src="/source/material/contactbg.png">
            <div class="container">
                <div class="row align-items-center hero-wrap justify-content-between mt-5 mb-5">
                    <div class="col-12 col-md-6 ">
                        <div class="wrapper">
                            <div class=" m-auto">
                                <h1>@t('site name')</h1>
                                <p class="text-justify">
                                    @t('site description')
                                </p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <div class="wrapper">
        <div class="main">
            <div class="contact-content">
                <div class="container">
                    <div class="row justify-content-between ">
                        <div class="col-12 col-md-6  mt-3">
                            @foreach ($contacts as $contact)
                                <h2><span class="eqlid_title">{{ $contact->xcontact_title }}</span></h2>
                                <div>
                                    {!! $contact->xcontact_desc !!}
                                </div>

                                <h3 class="mt-5"><span class="eqlid_title">
                                    @t('path to us')
                                    </span>
                                </h3>
                                <div class="row contact-items">
                                    @foreach ($contact->info()->orderBy('xrank', 'desc')->get() as $item)
                                        @switch($item->xcontactinfo_type)
                                            @case('Tel')
                                                <div class="col-12">
                                                    <div class="contact-info-item d-flex align-items-center">
                                                        <i class="icon-call"></i>
                                                        <a
                                                            href="tel:{{ $item->xcontactinfo_desc }}">{{ FarsiLib::convertDigit($item->xcontactinfo_desc) }}</a>
                                                    </div>
                                                </div>
                                            @break
                                            @case('Phone')
                                                <div class="col-12">
                                                    <div class="contact-info-item d-flex align-items-center">
                                                        <i class="icon-sms"></i>
                                                        <a
                                                            href="tel:{{ $item->xcontactinfo_desc }}">{{ FarsiLib::convertDigit($item->xcontactinfo_desc) }}</a>
                                                    </div>
                                                </div>
                                            @break
                                            @case('Fax')
                                                <div class="col-12">
                                                    <div class="contact-info-item d-flex align-items-center">
                                                        <i class="icon-fax"></i>
                                                        <a
                                                            href="tel:{{ $item->xcontactinfo_desc }}">{{ FarsiLib::convertDigit($item->xcontactinfo_desc) }}</a>
                                                    </div>
                                                </div>

                                            @break
                                            @case('Mail')
                                                <div class="col-12">
                                                    <div class="contact-info-item d-flex align-items-center">
                                                        <i class="icon-mail"></i>
                                                        <a
                                                            href="mailto:{{ $item->xcontactinfo_desc }}">{{ FarsiLib::convertDigit($item->xcontactinfo_desc) }}</a>
                                                    </div>
                                                </div>

                                            @break
                                            @case('Address')
                                                <div class="col-12">
                                                    <div class="contact-info-item d-flex align-items-center">
                                                        <i class="icon-locate"></i>
                                                        <a>{{ $item->xcontactinfo_desc }}</a>
                                                    </div>
                                                </div>

                                            @break
                                            @default

                                        @endswitch


                                    @endforeach

                                </div>
                            @endforeach
                            <h3 class="mt-5"><span class="eqlid_title">
                               @t('in socials')
                                </span></h3>
                            <div class="social-offer">
                                @if (@$social)
                                    @foreach ($social as $item)
                                        <a class="social-icon social-icon-sm social-icon-transparent social-{{ $item->xsocial_title }}"
                                            href="{{ $item->xsocial_link }}" title="{{ $item->xsocial_title }} address">
                                            <i class="icon-{{ $item->xsocial_title }}"></i>
                                            <i class="icon-{{ $item->xsocial_title }}"></i>
                                        </a>
                                    @endforeach
                                @endif
                            </div>

                        </div>

                        <div class="col-12 col-md-5  mt-3">
                            <h2 class="title"><span class="eqlid_title">
                                @t('call in us')
                                </span></h2>
                            <p class="description mb-3">
                                @t('start conversation')
                            </p>
                            <form role="form" id="contact-form" method="post" action="/Contact/sendForm">
                                @if (count($errors) > 0)
                                    <div class="alert alert-danger">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                                @if (Session::get('success'))
                                    <div class="alert alert-success">
                                        <button class="close" data-close="alert"></button>
                                        <span>{!! Session::get('success') !!}</span>
                                    </div>
                                @endif
                                <input type="hidden" class="field" name="_token" value="{{ csrf_token() }}">

                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="icon-login"></i></span>
                                    </div>
                                    <input type="text" name="name" class="form-control" value="{{ old('name') }}"
                                        placeholder="@t('name')" aria-label="Your Name...">
                                </div>
                                <label></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="icon-email"></i></span>
                                    </div>
                                    <input type="email" class="form-control" name="email" value="{{ old('email') }}"
                                        placeholder="@t('email')" aria-label="Email Here...">
                                </div>
                                <label></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="icon-tell"></i></span>
                                    </div>
                                    <input type="text" class="form-control" name="mobile" value="{{ old('mobile') }}"
                                        placeholder="@t('mobile')" aria-label="mobile Here...">
                                </div>
                                <label></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="icon-file"></i></span>
                                    </div>

                                    <select name="subject" class="form-control">
                                    <option value="0">@t('select')...</option>
                                    <option value="1">@t('tracking request')</option>
                                    <option value="2">@t('calim')</option>
                                    <option value="3">@t('other')</option>
                                </select>
                                </div>
                                <div class="form-group">
                                    <label></label>
                                    <textarea name="msg" placeholder="@t('message')" class="form-control" id="message"
                                        rows="6"></textarea>
                                </div>
                                <div class="comment-action row mb-5">
                                    <div class="col-12">
                                        {!! captcha_img('flat') !!}
                                        {{-- <div id="reCaptcha"><i class="icon-refresh"></i></div> --}}
                                        <input name="captcha" maxlength="8" type="text" value="{{ old('captcha') }}"
                                            placeholder="@t('Secure Code')" required>
                                        <input type="submit" class="btn" value="@t('send')">
                                    </div>
                                </div>



                            </form>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-12">
                            {!! $contacts[0]->xcontact_map !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection
