import $ from 'jquery'

export function setSubGroup(objData, first, group1, group2, group3, selected, titleOfSelect) {
    var src = $((typeof group1 == 'undefined') ? 'group1' : group1);
    var des = $((typeof group2 == 'undefined') ? 'group2' : group2);
    var src2 = $((typeof group3 == 'undefined') ? 'group3' : group3);
    var first = first ? first : 0;
    

    if (!src.length || !des.length || !objData) return;

    var desType = (typeof src.data('destype') != 'undefined' ? src.data('destype') : 'option');
    var desName = (typeof src.data('desname') != 'undefined' ? src.data('desname') : 'chk');

    if (typeof des.data('advancedselect') != 'undefined') {
        des.parent().find('.select2-container').remove();
    }

    var data = {};

    if (typeof src.val() == 'object' && desType == 'option' && !$.isEmptyObject(src.val())) {                  
        $.each(src.val(), function(key, val) {
            var text = (src.find('option[value="' + val + '"]').length ? src.find('option[value="' + val + '"]').first().text() : val);
            data[text] = objData[val]; 
        }); 
    } else if (src.val()) {
    	if (src2.val())
    		data = objData[src.val()][src2.val()];
    	else
        	data = objData[src.val()];
    } else {
        $.each(objData, function(key, val) {
            if (typeof val == 'object' && !$.isEmptyObject(val)) {
                $.each(val, function(k, v) {
                    data[k] = v;
                });
            } else {
                data[key] = val;
            }
        });
    }
    
    switch(desType) {
        case 'checkbox':
            des.empty();                    
            if (typeof data == 'undefined' || data.length == 0) {
                if (des.data('advancedselect') != undefined) {
                    App.setSelect2(des);
                }
                return;
            };
            if (typeof data == 'object') {
                $.each(data, function (key, val) {
                    var id = desName + key;
                    des.append('<input id="' + id + '" type="checkbox" name="' + desName + 
                        '[]" value="' + val + '"' + (src.data('checkall') != undefined ? 'checked="checked"' : '')  
                        + '>&nbsp;<label data-value="' + val + '">' + App.convertDigit(key, lang) + '</label>&nbsp;&nbsp;');
                });
            }
            break;
        default:
            des.find('option, optgroup').each(function (key) {
                if (key >= first) $(this).remove();
            });                    
            if (typeof data == 'undefined' || data.length == 0) {
                if (des.data('advancedselect') != undefined) {
                    App.setSelect2(des);
                }
                return;
            };
            if (typeof data == 'object') {
                if(titleOfSelect && typeof titleOfSelect != 'undefined'){
                    let opt = '<option value="' + 0 + '" disabled>' + titleOfSelect + '</option>';
                    des.append(opt);
                }
                $.each(data, function (key, val) {
                    var opt = null;
                    if (typeof val == 'object' && !$.isEmptyObject(val)) {
                    	
                    		opt = '<option value="' + key + '">' + val['title'] + '</option>';
                        	des.append(opt);	
                    	
                    } else if (typeof val != 'object')  {
                    	if (key != 'title'){
                    		opt = '<option value="' + key + '">' + val + '</option>';
                        	des.append(opt); 
                    	}
                    }                       
                });                        
            }
            
            des.find('option').each(function (key) {
                if ($(this).val() == src.data('selected') || (typeof selected != 'undefined' && $(this).val() == selected)) {
                    $(this).attr('selected', 'selected');
                }
            });
            break;    

    }
    if (des.data('advancedselect') != undefined) {
        App.setSelect2(des);
    }
}