import $ from 'jquery'
import 'slick-carousel'
import Swiper from 'swiper';

export function initialHomeSlick(){

	let bookSwiperOption= {
		// Optional parameters
	    //direction: 'vertical',
	    //freeMode: true,
	    //grabCursor: true,
	    //slidesPerGroup: 3,
      	//loopFillGroupWithBlank: true,
	    slidesPerView: 6,
	    spaceBetween: 30,

	    loop: false,
	    speed: 400,
	    autoplay: {
	        delay: 2500,
	        disableOnInteraction: false,
	    },

	    breakpoints: {
	        1200: {
	          slidesPerView: 5,
	          spaceBetween: 40,
	        },
	        992: {
	          slidesPerView: 4,
	          spaceBetween: 30,
	        },
	        768: {
	          slidesPerView: 3,
	          spaceBetween: 20,
	        },
	        480: {
	          slidesPerView: 2,
	          spaceBetween: 30,
	        },
	        320: {
	          slidesPerView: 1,
	          spaceBetween: 0,
	        }
	    },

	    // If we need pagination
	    pagination: {
	      el: '.book-row-carousel .swiper-pagination',
	      dynamicBullets: true
	    },

	    // Navigation arrows
	    navigation: {
	      nextEl: '.book-row-wrapper .swiper-button-next',
	      prevEl: '.book-row-wrapper .swiper-button-prev',
	    }
	}
	
	let myBookSwiper = []
	$('.book-row-carousel').each(function(){
		let newElm = '.brc-'+$(this).data('module');
		let temp = bookSwiperOption;
		temp.pagination.el = newElm + ' .book-row-carousel' + ' .swiper-pagination'
		temp.navigation.nextEl = newElm + ' .swiper-button-next'
		temp.navigation.prevEl = newElm + ' .swiper-button-prev'
		myBookSwiper.push(new Swiper(newElm + ' .book-row-carousel', temp));
	})
	
	let categorySwiperOption = {
	    slidesPerView: 6,
	    spaceBetween: 10,
	    loop: false,
	    speed: 400,
	    autoplay: {
	        delay: 2500,
	        disableOnInteraction: false,
	    },
	    breakpoints: {
	        1200: {
	          slidesPerView: 5,
	          spaceBetween: 40,
	        },
	        992: {
	          slidesPerView: 4,
	          spaceBetween: 30,
	        },
	        768: {
	          slidesPerView: 3,
	          spaceBetween: 20,
	        },
	        480: {
	          slidesPerView: 2,
	          spaceBetween: 30,
	        },
	        320: {
	          slidesPerView: 1,
	          spaceBetween: 0,
	        }
	    },

	    // If we need pagination
	    pagination: {
	      el: '.category-row-carousel .swiper-pagination',
	      dynamicBullets: true
	    },

	    // Navigation arrows
	    navigation: {
	      nextEl: '.book-row-wrapper .swiper-button-next',
	      prevEl: '.book-row-wrapper .swiper-button-prev',
	    }
	};
	let myCategorySwiper = []
	$('.category-row-carousel').each(function(){
		let newElm = '.brc-'+$(this).data('module');
		let temp = categorySwiperOption;
		temp.pagination.el = newElm + ' .category-row-carousel' + ' .swiper-pagination'
		temp.navigation.nextEl = newElm + ' .swiper-button-next'
		temp.navigation.prevEl = newElm + ' .swiper-button-prev'
		myCategorySwiper.push(new Swiper(newElm + ' .category-row-carousel', temp));
	})
}

export function initialHomeBlog(){
	let myBlogHomeSwiper = new Swiper('.home-article-carousel', {

	    slidesPerView: 4,
	    spaceBetween: 10,

	    loop: false,
	    speed: 400,

    	autoplay: {
	        delay: 2500,
	        disableOnInteraction: false,
	    },

	    breakpoints: {
	        1200: {
	          slidesPerView: 3,
	          spaceBetween: 10,
	        },
	        992: {
	          slidesPerView: 2,
	          spaceBetween: 10,
	        },
	        768: {
	          slidesPerView: 2,
	          spaceBetween: 10,
	        },
	        480: {
	          slidesPerView: 1,
	          spaceBetween: 10,
	        }
	    },

	    

	    // Navigation arrows
	    navigation: {
	      nextEl: '.blog-wrapper .swiper-button-next',
	      prevEl: '.blog-wrapper .swiper-button-prev',
	    }
	});
};

export function intialHomeBanner(){
	var slidesh = document.querySelectorAll('.banner-carousel .swiper-slide');
	let myBannerSwiper = new Swiper('.banner-carousel', {
		// Optional parameters
	    //direction: 'vertical',
	    slidesPerView: 1,
	    spaceBetween: 0,
		loop: slidesh.length > 1 ? true : false,
      	watchOverflow: true,
	    speed: 400,
		autoplay: {
			delay: 5000,
		  },
    	

	    // If we need pagination
	    pagination: {
	      el: '.banner-carousel .swiper-pagination',
	      dynamicBullets: true
	    },

	    // Navigation arrows
	    navigation: {
	      nextEl: '.banner-carousel .swiper-button-next',
	      prevEl: '.banner-carousel .swiper-button-prev',
	    }
	});
	
};

export function initialHomePartner(){
	let myPartnerHomeSwiper = new Swiper('.home-partner-carousel', {

	    slidesPerView: 5,
	    spaceBetween: 10,

	    loop: false,
	    speed: 400,

    	autoplay: {
	        delay: 5000,
	        disableOnInteraction: false,
	    },

	    breakpoints: {
	        1200: {
	          slidesPerView: 3,
	          spaceBetween: 10,
	        },
	        992: {
	          slidesPerView: 2,
	          spaceBetween: 10,
	        },
	        768: {
	          slidesPerView: 2,
	          spaceBetween: 10,
	        },
	        480: {
	          slidesPerView: 1,
	          spaceBetween: 10,
	        }
	    },

	    // If we need pagination
	    pagination: {
	      el: '.home-partner-carousel .swiper-pagination',
	      dynamicBullets: true
	    },

	    // Navigation arrows
	    navigation: {
	      nextEl: '.partner-wrapper .swiper-button-next',
	      prevEl: '.partner-wrapper .swiper-button-prev',
	    }
	});
};
