@section('content')
<div class="container survey-wrapper">
<div class="survey-title d-flex justify-content-center flex-column align-items-center">
	<img src="/eqlid/logo.png" alt="eqlid">
	<h1> با شرکت در نظرسنجی ما را در بهبود خدمات یاری نمایید </h1>
</div>
<hr>
<div class="survey-warning">
	<h6 class="p-2 m-0 text-center">مشتری گرامی جهت دریافت خدمات، ارائه کارت ملی / کد ملی به تکنسین الزامی می باشد.</h6>
</div>
@if(!$isBeforeRegister)
	@include('eqlid::index.survey.questions')
@endif
<div class="c-comment mt-2">
	<div class="row justify-content-center">
		@foreach(@$technicians as $key=>$technician)
		<div class="col-12 col-md-7">
			<div class="c-cart c-profile-comment-card technician-box-style1">
				<div class="row align-items-center no-gutters">
				 <div class="col-5">
					<div class="pt-3 pl-3">
						<img width="120" class="img-responsive image avatar " itemprop="image" src="{{'/pic/gstechnician/' . $technician['code'] .'/'.$technician['code']. '.png'}}" alt="{{$technician['name']}}">
					</div>
				</div>
				<div class="col-7">
					<div class="">
						<h3 class="mb-1 black">{{$technician['name']}}</h3>
						<span class="bold">کد تکنسین : </span><span> {{FarsiLib::convertDigit($technician['code'])}}</span><br>
						<!-- {{-- <span class="bold">شماره همراه  : </span><span> {{FarsiLib::convertDigit($technician['Mobile'])}}</span><br> --}} -->
						
					</div>
				</div>
				</div>
				<div class="mt-4">
				<div class="accordions" id="faq-accordions">
                    @foreach ($technician['items'] as $item)
                    <div class="accordion">
                        <div class="accordion-title collapsed" data-toggle="collapse" data-target="#collapse{{$loop->iteration}}-{{$key}}" aria-expanded="true" aria-controls="collapse{{$loop->iteration}}">
                            <h4 class="accordion-title-inner">{{$services[$item['ServiceTypeID']]. ' ' . $item['ProductFarsiName']}}</h4>
                        </div>
                        <div id="collapse{{$loop->iteration}}-{{$key}}" class="collapse accordion-content" aria-labelledby="heading{{$loop->iteration}}"
                            data-parent="#faq-accordions">
                            <div class="accordion-content-inner">
								<span>سریال دستگاه : </span> {{@$item['Serial']}} <br>
								<span>مدل دستگاه : </span> {{@$item['Model']}} <br>
								<span>تاریخ ثبت : </span> {{FarsiLib::faNormalize($item['ReceiptD'],true)}} <br>
                            </div>
                        </div>
                    </div>
                    @endforeach
                                      
                </div>
				</div>
			</div>
			
		</div>
		@endforeach
		
	</div>
</div>
@if($hasPeriodicService)
	<h3 class="text-center mb-5">اقدامات تکنسین در سرویس دوره ای </h3>
	<div class="row justify-content-center technician-work-cart">
		<div class="col-12 col-md-7">
			<div class="c-cart c-profile-comment-card flex-row align-items-center no-gutters">
				 <div class="col-4">
					<div class="c-profile-card-img">
						<img width="135" height="100%" class="img-responsive image" itemprop="image" src="{{'/pic/eqlidproduct.image/' . 25 . 'w135h150c0/' . str_random() . '.png?nocache=1'}}" alt="ساید بای ساید">
					</div>
				</div>
				<div class="col-8">
					<div class="c-profile-card-content heightUnset">
						<!-- <h3 class="mb-1 red">ساید بای ساید : </h3> -->
						<span >تکنسین دستگاه را جهت نشتی آب  بررسی می نماید. </span><br>
						<span >تکنسین فشار آب دستگاه را بررسی می نماید.</span><br>
						<span >تکنسین سرمایش دستگاه را بررسی می نماید.</span><br>
						<span >تکنسین کاور پشت دستگاه را باز و داخل آن را شستشو  می نماید.</span><br>
					</div>
				</div>
			</div>
		</div>

		<div class="col-12 col-md-7">
			<div class="c-cart c-profile-comment-card flex-row align-items-center no-gutters">
				 <div class="col-4">
					<div class="c-profile-card-img">
						<img width="135" height="100%" class="img-responsive image" itemprop="image" src="{{'/pic/eqlidproduct.image/' . 18 . 'w135h150c0/' . str_random() . '.png?nocache=1'}}" alt="ساید بای ساید">
					</div>
				</div>
				<div class="col-8">
					<div class="c-profile-card-content heightUnset">
						<!-- <h3 class="mb-1 red">لباسشویی : </h3> -->
						<span >تکنسین داخل دستگاه را شستشو می نماید. </span><br>
						<span >تکنسین صافی شیربرقی پشت دستگاه را تمیز می نماید.</span><br>
						<span >تکنسین فیلتر تخلیه آب را تمیز می نماید.</span><br>
					</div>
				</div>
			</div>
		</div>

		<div class="col-12 col-md-7">
			<div class="c-cart c-profile-comment-card flex-row align-items-center no-gutters">
				 <div class="col-4">
					<div class="c-profile-card-img">
						<img width="135" height="100%" class="img-responsive image" itemprop="image" src="{{'/pic/eqlidproduct.image/' . 20 . 'w135h150c0/' . str_random() . '.png?nocache=1'}}" alt="ساید بای ساید">
					</div>
				</div>
				<div class="col-8">
					<div class="c-profile-card-content heightUnset">
						<!-- <h3 class="mb-1 red">ظرفشویی : </h3> -->
						<span >تکنسین از کاغذ تست جهت آزمایش آب استفاده می نماید.</span><br>
						<span >تکنسین مخزن نمک را بررسی می نماید.</span><br>
						<span >تکنسین مخزن جلا دهنده را بررسی می نماید. </span><br>
						<span >تکنسین صافی شیربرقی پشت دستگاه را تمیز می نماید.</span><br>
					</div>
				</div>
			</div>
		</div>

		<div class="col-12 col-md-7">
			<div class="c-cart c-profile-comment-card flex-row align-items-center no-gutters">
				 <div class="col-4">
					<div class="c-profile-card-img">
						<img width="135" height="100%" class="img-responsive image" itemprop="image" src="{{'/pic/eqlidproduct.image/' . 23 . 'w135h150c0/' . str_random() . '.png?nocache=1'}}" alt="ساید بای ساید">
					</div>
				</div>
				<div class="col-8">
					<div class="c-profile-card-content heightUnset">
						<!-- <h3 class="mb-1 red">مایکروویو : </h3> -->
						<span >تکنسین عایق داخل دستگاه را بازدید می نماید.</span><br>
						<span >تکنسین داخل دستگاه را تمیز می نماید.</span><br>
					</div>
				</div>
			</div>
		</div>
	</div>
	@endif
</div>

@endsection
