{{--@include('eqlid::index.survey.message') --}}
<div class="survey-question-box">
    <form class="needs-validation survey-form" method="POST" action="/{{ config('app.controller') }}/register">
        @csrf
        <div class="row">
            @foreach($questions as $question)
                <div class="col-12 mt-4">
                    <div class="question-box" data-id="{{ $question->otherid }}">
                        <h4>{{ FarsiLib::convertDigit($question->name) }}</h4>
                        <div class="error c-ui-feedback-hint">تکمیل این قسمت الزامی می باشد.</div>
                        <div class="form">
                            @if($question->type == 6)
                                <div class="radiosSlider  dir-ltr w-100">
                                    @foreach($question->answers()->orderBy('order','asc')->get() as $answer)
                                        <input type="radio" id="answerRadio{{ $answer->otherid }}"
                                            name="answers[{{ $question->otherid }}]" value="{{ $answer->otherid }}"
                                            class="radioVoc" required>
                                        <label
                                            for="answerRadio{{ $answer->otherid }}">{{ FarsiLib::convertDigit($answer->name) }}</label>
                                    @endforeach
                                </div>
                            @elseif($question->type == 2)
                                @var('questionTemp',$question->answers()->orderBy('order','asc')->get())
                                    @if($questionTemp->count())
                                        <div class="survey-slider"
                                            data-config='{"min":{{ $questionTemp->first()->value }},"max":{{ $questionTemp->last()->value }},"config":{{ $question->config }}}'>
                                            <ul role="presentation">
                                                @foreach($questionTemp as $answer)
                                                    <li data-id="{{ $answer->otherid }}"
                                                        data-value="{{ $answer->value }}"
                                                        data-name="{{ $answer->name }}">
                                                        @if($loop->first || $loop->last)
                                                            <span>{{ FarsiLib::convertDigit($answer->name) }}</span>
                                                        @endif
                                                    </li>
                                                @endforeach
                                            </ul>
                                            <div></div>
                                            @var('defaultValueId',$questionTemp->where('value',json_decode($question->config)->defaultValue)->first())
                                                <input class="answer" type="hidden"
                                                    name="answers[{{ $question->otherid }}]" value="{{@$defaultValueId !== null ? $defaultValueId->otherid : null }}" required>
                                        </div>
                                    @endif
                                @elseif($question->type == 3)
                                    <div class="form-group">
                                        <textarea class="form-control" rows="3"
                                            name="comment[{{ $question->otherid }}]"></textarea>
                                    </div>
                                @else
                                    @foreach($question->answers as $answer)
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="answerRadio{{ $answer->otherid }}"
                                                name="answers[{{ $question->otherid }}]" class="custom-control-input"
                                                value="{{ $answer->otherid }}" required>
                                            <label class="custom-control-label"
                                                for="answerRadio{{ $answer->otherid }}">{{ FarsiLib::convertDigit($answer->name) }}</label>
                                        </div>
                                    @endforeach
                                @endif
                        </div>
                    </div>
                </div>
                @if($question->isvoc)
                    <div class="col-12 voc-wrapper mt-4">
                        <h5 class="text-center voc-title">{{json_decode($question->config)->defaultTitle}}</h5>
                        <div class="error c-ui-feedback-hint">حداقل یکی از موارد زیر را انتخاب نمائید</div>
                        <div class="row no-gutters">
                            @foreach($voc as $item)
                                <div class="col-6 col-md-6 stateOff voc-item">
                                    <div class=" voc-checkbox" data-id="{{ $item->id }}"
                                        data-forigenid="{{ $item->otherid }}">
                                        {{ $item->name }}
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <input type="hidden" name="voc">
                    </div>
                @endif
            @endforeach
            <div class="col-12 d-flex justify-content-center">
                <button class="btn mb-5 mt-5 survey-submit-btn" type="submit">ثبت نظرسنجی</button>
            </div>
        </div>
        <input type="hidden" name="customerCode" value="{{ @$customerCode }}">
        <input type="hidden" name="serviceNo" value="{{ @$serviceNo }}">
    </form>

</div>
<script type="text/javascript">
    var vocList = {!!json_encode($vocList) !!};

</script>
