@section('content')
<div class="request-body">
    <div class="blog-banner-holder">
        <div class="container">
            <div class="row align-items-center hero-wrap justify-content-between">
                <div class="col-12 col-md-5 pl-0 pr-0 heroImg order-first">
                    <img itemprop="image" src="/eqlid/material/request.png" alt="Hero Image" width="950" height="870" class="img-fluid">
                </div>
                <div class="col-12 col-md-6 pl-0 pr-0 heroTxt">
                    <div class="wrapper">
                        <div class=" m-auto">
                            <h1> درخواست خود را در سریعترین زمان ثبت کنید</h1>
                            <p>
                                کافیه چند ثانیه ای وقت بگذارید و درخواستتون را در سیستم ثبت کنید. کارشناسان ما در سریعترین زمان ممکن با شما تماس گرفته و
                                تکنسین مربوطه را به خانه شما ارسال می کنند.
                            </p>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<div class="container">
    <div class="row">
        <div class="col-12 col-lg-11 form-box">
            <form role="form" action="" method="post" class="f1">

                <div class="f1-steps">
                    <div class="f1-progress">
                        <div class="f1-progress-line" data-now-value="20" data-number-of-steps="5" style="width: 20%;"></div>
                    </div>
                    <div class="f1-step d-flex align-items-center active justify-content-center justify-content-md-start" data-step-number="1">
                        <div class="f1-step-icon">۱</div>
                        <span class="d-none d-md-block">انتخاب نوع خدمت</span>
                    </div>
                    <div class="f1-step d-flex align-items-center justify-content-center justify-content-md-start" data-step-number="2">
                        <div class="f1-step-icon">۲</div>
                        <span class="d-none d-md-block">انتخاب برند </span>
                    </div>
                    <div class="f1-step d-flex align-items-center justify-content-center justify-content-md-start" data-step-number="3">
                        <div class="f1-step-icon">۳</div>
                        <span class="d-none d-md-block">انتخاب گروه محصول</span>
                    </div>
                    <div class="f1-step d-flex align-items-center justify-content-center justify-content-md-start" data-step-number="4">
                        <div class="f1-step-icon">۴</div>
                        <span class="d-none d-md-block">انتخاب محصول</span>
                    </div>
                    <div class="f1-step d-flex align-items-center justify-content-center justify-content-md-start" data-step-number="5">
                        <div class="f1-step-icon">۵</div>
                        <span class="d-none d-md-block">نمایش اطلاعات </span>
                    </div>
                </div>
                
                <fieldset style="display:block;" class="ServiceFieldList" data-step-number="1">
    @include('eqlid::index.request.services',[ 'title' => 'متقاضی کدامیک از خدمات گلدیران هستید؟ ', 'list' => [ [ 'id' =>
                    '3', 'name' => 'نصب و راه اندازی',  'icon' => 'icon-setup', ], [
                    'id' => '4', 'name' => 'سرویس دوره ای',  'icon' => 'icon-periodic',
                    ], [ 'id' => '2', 'name' => 'تعمیرات',  'icon' => 'icon-repaire',
                    ], [ 'id' => '7', 'name' => 'تمدید گارانتی',  'icon' => 'icon-warranty',
                    ], ] ])

                </fieldset>


                <fieldset class="request-products BrandFieldList" data-step-number="2">
                    @include('eqlid::index.request.services',[ 'title' => 'محصول شما در کدام گروه قرار می گیرد ؟', 'list' => $fullBrandList ])
                    <button type="button" class="btn btn-previous btn-dark">مرحله قبل</button>
                </fieldset>

                <fieldset class="request-products GroupFieldList" data-step-number="3">
                    @include('eqlid::index.request.services',[ 'title' => 'محصول شما در کدام گروه قرار می گیرد ؟', 'list' => $fullGroupList ])
                    <button type="button" class="btn btn-previous btn-dark">مرحله قبل</button>
                </fieldset>

                <fieldset class="request-products ProductFieldList" data-step-number="4">
                    @include('eqlid::index.request.services',[ 'title' => 'محصول شما چیست ؟', 'list' => $fullProductList ])
                    <button type="button" class="btn btn-previous btn-dark">مرحله قبل</button>
                </fieldset>
                <fieldset data-step-number="5">
                    <div class="js-last-step-form">
                        <h4 class="mt-3"> اطلاعات شخصی</h3>
                        <div class="row">                            
                            <div class="col-12 col-md-6 mb-3 mb-3">
                                <input name="info[fname]" type="text" class="form-control js-fname-input" placeholder="نام" data-valid="only-text" value="{{@$user->userInfo->xname}}">
                                <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                            </div>
                            <div class="col-12 col-md-6">
                                <input name="info[lname]" type="text" class="form-control js-lname-input" placeholder="نام خانوادگی" data-valid="only-text" value="{{@$user->userInfo->xfamily}}">
                                <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل حروف باشد</div>
                            </div>
                            
                        </div>

                        <h4 class="mt-3">  اطلاعات تماس</h3>
                        <div class="row">
                              @var('address',@$user ? @$user->address()->first() : null)
                                <div class="col-12 col-md-4 mb-3">
                                    <input name="info[hometel]" type="text" min="11" max="11" class="form-control js-hometel-input" placeholder="تلفن منزل" data-valid="only-number" value="{{@$address->xaddress_home_phone}}">
                                    <div class="error c-ui-feedback-hint"> فیلد الزامی و فقط شامل اعداد مانند 02122334455</div>
                                </div>
                                <div class="col-12 col-md-4 mb-3">
                                    <input name="info[mobile]" type="text" min="11" max="11" class="form-control js-mobile-input" placeholder="تلفن همراه " data-valid="only-number" value="{{@$user->userInfo->xmobile}}">
                                    <div class="error c-ui-feedback-hint">فیلد الزامی و فقط شامل اعداد مانند 09123456789</div>
                                </div>
                                <div class="col-12 col-md-4">
                                    <input name="info[officetel]" type="text" class="form-control js-officetel-input" placeholder="تلفن محل کار (اختیاری) ">
                                </div>
                        </div>

                        <h4 class="mt-3">  مشخصات آدرس </h3>
                        <div class="row">
                                <div class="col-12 col-md-3 mb-3">
                                    {!! Form::select('', @$provinceList, @$address->xprovinceid ?? 0, ['class' => 'form-control groupList', 'id' => 'provinceListCombo' , 'data-valid'=>'only-number']) !!}
                                </div>
                                <div class="col-12 col-md-3 mb-3">
                                    {!! Form::select('info[cityid]', [@$address->xcityid ?? 0 => ' شهر'], @$address->xcityid ?? 0, ['class' => 'form-control groupList', 'id' => 'cityListCombo', 'data-valid'=>'only-number']) !!}
                                </div>
                                <div class="col-12 col-md-3 mb-3">
                                    {!! Form::select('info[regionId]', [$address->xregionid ?? 0=> ' منطقه'], @$address->xregionid ?? 0, ['class' => 'form-control productList', 'id' => 'regionListCombo', 'data-valid'=>'only-number']) !!}
                                    <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                </div>
                                <div class="col-12 col-md-3 mb-3">
                                    {!! Form::select('info[parishId]', [$address->xparishid ?? 0 => ' محله'], $address->xparishid ?? 0, ['class' => 'form-control productList', 'id' => 'parishListCombo', 'data-valid'=>'only-number']) !!}
                                    <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                </div>
                                <div class="col-12 mt-3 mb-3">
                                    <input name="info[address]" type="text" class="form-control js-adddress-input" placeholder="آدرس" data-valid="text" value="{{@$address->xaddress_content}}">
                                    <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                </div>
                                <div class="col-12 mt-3 mb-3">
                                    <textarea name="r[f][remark]" rows="2"  class="form-control js-remark-input" placeholder="توضیحات"></textarea>
                                </div>
                                <input type="hidden" name="r[f][svctypeid]" value="0" id="firstsvstypeid">
                                <input type="hidden" name="r[f][productcode]" value="0" id="firstproductcode">
                        </div>
                        <div class="new-requests d-none">
                        <div class="new-request-row select-chain-row">
                                <h4 class="mt-3">  اطلاعات درخواست جدید </h3>
                                <div class="row">
                                    <div class="col-12 col-md-3 mb-2">
                                        {!! Form::select('r[row1][svctypeid]',['0'=>'انتخاب نوع سرویس','3' => 'نصب و راه اندازی','4'=>'سرویس دوره ای','2'=>'تعمیر','7'=>'تمدید گرانتی',], 0, ['class' => 'form-control ', 'data-valid'=>'only-number']) !!}
                                         <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                    </div>
                                    <div class="col-12 col-md-3 mb-2">
                                            {!! Form::select('', @$brandList, null, ['class' => 'form-control brandList',  'data-valid'=>'only-number']) !!}
                                            <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                        </div>
                                    <div class="col-12 col-md-3 mb-2">
                                        {!! Form::select('', [0 => 'نام گروه'], null, ['class' => 'form-control groupList',  'data-valid'=>'only-number']) !!}
                                        <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                    </div>
                                    <div class="col-12 col-md-3 mb-2">
                                        {!! Form::select('r[row1][productcode]', [0 => 'نام محصول'], null, ['class' => 'form-control productList ',  'data-valid'=>'only-number']) !!}
                                        <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                    </div>
                                    <div class="col-12 mb-2">
                                        <input name="r[row1][remark]" type="text" class="form-control js-remark-input" placeholder="توضیحات" >
                                        <div class="error c-ui-feedback-hint"> فیلد الزامی می باشد</div>
                                    </div>
                                </div>
                                <div class=" new-request-btn-style new-request-plus">
                                    <i class="icon-plus"></i>
                                </div>
                        </div>
                        </div>
                        <button type="button" class="btn btn-previous btn-dark">مرحله قبل</button>
                        <button type="button" class="btn btn-danger js-submit-insert-request">ثبت درخواست </button>
                    </div>
                    

                    <div class="row d-none js-last-step-message">
                            <div class="col-12">
                                <div class="cart-list text-center result-bank-cart">
                                    <div class="cart-alert-icon  success">
                                        <i class="icon-check"></i>
                                        {{-- icon-close --}}
                                    </div>
                                    <div class="request-response-parent">
                                    <div class="request-response-row mb-3">
                                         درخواست <span class="serviceName">تعمیر و سرویس</span> برای <span class="productName">جاروبرقی</span>  با شماره پیگیری <span class="codeName"></span> با موفقیت ثبت شد.
                                    </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                                جهت اطلاع از وضعیت درخواست خود در اینده می توانید از طریق <a href="/Request/followRequest">پیگیری درخواست</a> اقدام نمایید
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                </fieldset>
                

            </form>
            <div class="request-vertical-timeline d-none d-lg-block">
                    <div class="timeline">
                        <a href="#00/00/2013" data-date="00/00/2013" class="first selected" >
                            <div class="text-content highlight text-lg">
                               <span class="bold"> نوع سرویس</span> <br>
                               <span class="js-timeline-service"></span>
                            </div>
                        </a>    
                        <a href="#22/01/2015" data-date="22/01/2015" class="second" >
                            <div class="text-content highlight text-lg">
                                    <span class="bold">گروه محصول</span> <br>
                                    <span class="js-timeline-group"></span>
                            </div>
                        </a>
                        <a href="#22/01/2016" data-date="22/01/2016" class="three">
                            <div class="text-content highlight text-lg">
                                        <span class="bold">محصول</span> <br>
                                        <span class="js-timeline-product"></span>
                            </div>
                        </a>
                        <span class="filling-line" aria-hidden="true"></span>
                    </div>
            </div>
        </div>
    </div>

</div>
@include('eqlid::index.request.confirmmodal')
<script type="text/javascript">
    var productList = {!! json_encode($productList) !!};
    var groupList = {!! json_encode($groupList) !!};
    var cityList = {!! json_encode($cityList) !!};
    var regionList = {!! json_encode($regionList) !!};
    var parishList = {!! json_encode($parishList) !!};

</script>
@endsection