@section('content')
<amp-animation layout="nodisplay" id="anim1" trigger="visibility">
  <script type="application/json">
    {
      "selector": ".pb-down",
      "duration": "0.4s",
      "easing": "cubic-bezier(0,0,.21,1)",
      "keyframes": "transition1"
    }
  </script>
</amp-animation>

<amp-state id="level">
    <script type="application/json">
      {
        "cupcakes": {
          "imageUrl": "https://amp.dev/static/samples/img/image2.jpg",
          "style": "greenBorder"
        },
        "sushi": {
          "imageUrl": "https://amp.dev/static/samples/img/image3.jpg",
          "style": "redBorder"
        }
      }
    </script>
  </amp-state>

<div id="app">
  <div class="pb-1">
    <div class="primary-box pb-1-primary">
      <div class="pb-up">
        <amp-img  on="tap:anim1.start" alt="گلدیران مشتریان" width="170" height="57" src="public/eqlid/logo-white.webp"></amp-img>
      </div>
      <div class="pb-down secondary-box">
        <div class="layout-box">
          <main>
            <div>
              <p class="bold font-xl">
                به خانواده گلدیران خوش آمدید.
              </p>
              <p class="mt-xl">
                جهت استفاده بهینه از خدمات گلدیران می توانید از همان ابتدا با شماره خود وارد سیستم شوید
            </p>
            </div>
            <div class="form-controller mt-xxl">
              <div class="label bold">شماره موبایل</div>
              <div class="text-input mt-l">
                <div class="input-container">
                  <input type="tel" class="input" placeholder="مثلاً ۰۹۱۲۳۴۵۶۷۸۹" autocorrect="off" id="login-input" maxlength="11" value="">
                </div>
              </div>
            </div>
          </main>
          <footer>
            <button type="submit" class="button dash-button" id="next-button">شماره موبایل نمی دهم!</button>
            <button type="submit" class="button primary-box" id="next-button">مرحله بعد</button>
          </footer>
        </div>
      </div>
    </div>
  </div>

  <div class="pb-2 d-none">
  </div>
</div>
@endsection

@section('scripts')
    <script async custom-element="amp-animation" src="https://cdn.ampproject.org/v0/amp-animation-0.1.js"></script>
@endsection

@section('styles')
  @php 
    include(resource_path('views/index/eqlid/css/') . '/base.css');
    include(resource_path('views/index/eqlid/css/') . '/bootstrap-grid.css');
    include(resource_path('views/index/eqlid/modules/eqlid/views/index') . '/amp-request.css');
  @endphp
@endsection