import jquery from 'jquery'
// import 'jquery-ui';
window.$ = window.jQuery = jquery;
require('./jquery-ui.min.js');
require('./jquery.ui.touch-punch.min.js');

import {
    DigitHelper
} from '../../../../js/helper/digitHelper'
// import index from './radios-to-slider.js'

export class Survey {
    constructor() {
        this.tooltipElement = $('<div class="ui-slider-tooltip" aria-hidden="true" />');
        this.tooltip = '';
        this.submitBtn = $('.survey-submit-btn');
        this.questionsForm = $('.survey-form');
    }

    buttonLoading(isLoading) {
        if (isLoading) {
            this.submitBtn.append('<span class="spinner-grow" role="status" aria-hidden="true"></span>');
            this.submitBtn.addClass("disabled");
        } else {
            this.submitBtn.find('.spinner-grow').remove();
            this.submitBtn.removeClass("disabled");
        }
    }

    validateForm() {
        
        let isError = false;
        this.questionsForm.find('input').each(function () {
            let value = $(this).val();
            if ($(this).attr('type') == 'radio') {
                let name = $(this).attr('name');
                value = $('input[name="' + name + '"]:checked').val()
            }

            if ($(this).prop('required') && (value == "" || value == undefined)) {
                isError = true;
                $(this).closest('.question-box').addClass('input-error');
            } else {
                $(this).closest('.question-box').removeClass('input-error');
            }
        });
        return isError;
    }

    submitSurvey() {
        this.submitBtn.on('click', (event) => {
            event.preventDefault();

            if (this.validateForm()) {
                this.scroll_to_class($('.survey-form'), 10);
                return;
            }
            //new edit
            this.questionsForm.submit();
            return;
            //end edit
            
            var url = this.questionsForm.attr('action');

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: "POST",
                url: url,
                data: this.questionsForm.serialize(), // serializes the form's elements.
                beforeSend: () => {
                    this.buttonLoading(true);
                },
                error: (xhr, ajaxOptions, thrownError) => {
                    this.messageBoxSetup(xhr.responseJSON);
                    this.buttonLoading(false);
                },
                success: (data) => {
                    this.messageBoxSetup(data);
                    this.buttonLoading(false);
                }
            });

            return false;
        });
    }



    messageBoxSetup(data) {
        if (data.status) {
            $('.survey-messsage-box .cart-alert-icon').attr('class', 'cart-alert-icon success')
            $('.survey-messsage-box .cart-alert-icon i').attr('class', 'icon-check')
            if (data.button) {
                $('.survey-messsage-box .cart-alert-btn').attr('href', data.button.link)
                $('.survey-messsage-box .cart-alert-btn').text(data.button.text)
            } else {
                $('.survey-messsage-box .button-wrapper').addClass('d-none');
            }
        } else {
            $('.survey-messsage-box .cart-alert-icon').attr('class', 'cart-alert-icon failed')
            $('.survey-messsage-box .cart-alert-icon i').attr('class', 'icon-close')
        }

        $('.survey-messsage-box .cart-alert-message').html(data.message)
        $('.survey-question-box').addClass('d-none');
        $('.survey-messsage-box').removeClass('d-none');
    }



    binding() {
        this.questionsForm.find('input').on('focus', function () {
            $(this).closest('.question-box').removeClass('input-error');
        });

        this.submitSurvey();
        if ($('.survey-slider').length) {
            const sliderConfig = $('.survey-slider').data('config');
            let activeClass = {
                'background': sliderConfig.config.defaultColor,
                'border-color': sliderConfig.config.defaultColor
            };
            $(document).on('click', '.voc-checkbox', function (event) {
                $(this).toggleClass('active');
                $(this).closest('.question-box').removeClass('input-error');

                if ($(this).hasClass('active')) {
                    $(this).css(activeClass);
                } else {
                    $(this).removeAttr('style')
                }
                let vocElem = [];
                $('.voc-checkbox.active').each(function () {
                    vocElem.push($(this).data('forigenid'));
                })
                $('input[name="voc"]').val(JSON.stringify(vocElem));
            });

            $('.survey-slider').addClass(sliderConfig.config.theme);
            $('.survey-slider ul li').each(function (index) {

                $(this).css('left', (index / (sliderConfig.max - sliderConfig.min) * 100).toFixed(2) + '%');
            });
            if ($('.survey-slider').length) {

                let slider = $('.survey-slider > div').slider({
                    range: "min",
                    value: sliderConfig.config.defaultValue,
                    min: sliderConfig.min,
                    max: sliderConfig.max,
                    step: 1,
                    create: (event) => {
                        const slider = $(event.target)
                        slider.prepend('<div class="slider-range-inverse"></div>')
                        slider.find('.ui-slider-handle').append(this.tooltipElement);
                        this.tooltip = $('.ui-slider-tooltip');
                        //debugger
                        //this.update_handle_track_pos(event.target, $(this).slider("value"));

                    },
                    change: (event, ui) => {
                        var input = $(event.target).parent().find('input.answer');
                        const answer = $('.survey-slider li[data-value="' + ui.value + '"]');
                        
                        const answerId = answer.data('id');
                        const answerName = answer.data('name');
                        input.val(answerId);
                        this.tooltip.text(DigitHelper.writeNumber(answerName));
                        if (ui.value != sliderConfig.min && ui.value != sliderConfig.max)
                            this.tooltip.attr('aria-hidden', 'false');

                        this.clearVoc();
                        $('.voc-wrapper .voc-item').addClass('stateOff');
                        const answerid = answer.first().data('id');
                        //const activeClass = ui.value >= sliderConfig.config.range[1] ? 'greenActive' : (ui.value >= sliderConfig.config.range[0] ? 'yellowActive' : 'redActive');
                        if (sliderConfig.config.range) {
                            let isClassSet = false;
                            const keys = Object.keys(sliderConfig.config.range).sort();
                            for (let index = keys.length - 1; index >= 0; index--) {
                                const key = keys[index];
                                if (ui.value >= key) {
                                    activeClass = {
                                        'background': sliderConfig.config.range[key].color,
                                        'border-color': sliderConfig.config.range[key].color
                                    };
                                    this.changeVocTitle(sliderConfig.config.range[key].title);
                                    isClassSet = true;
                                    break;
                                }
                            }
                            if (!isClassSet) {
                                activeClass = {
                                    'background': sliderConfig.config.defaultColor,
                                    'border-color': sliderConfig.config.defaultColor
                                };
                                this.changeVocTitle(sliderConfig.config.defaultTitle);
                            }
                        }
                        $.each(vocList[parseInt(answerid)], function (key, value) {
                            $('.voc-wrapper').find('*[data-id="' + key + '"]').parent().removeClass('stateOff');
                        });

                    },
                    slide: (event, ui) => {
                        this.tooltip.attr('aria-hidden', 'true');
                        let color = sliderConfig.config.defaultColor;
                        if (sliderConfig.config.range) {
                            const keys = Object.keys(sliderConfig.config.range).sort();
                            for (let index = keys.length - 1; index >= 0; index--) {
                                const key = keys[index];
                                if (ui.value >= key) {
                                    color = sliderConfig.config.range[key].color;
                                    break;
                                }
                            }
                        }
                        $('.slider-range-inverse').css('background', color);
                        // if (ui.value >= sliderConfig.min)
                        //     $('.slider-range-inverse').css('background','#cc2b2b');
                        // if (ui.value >= sliderConfig.config.range[0])
                        //     $('.slider-range-inverse').css('background','#ffc107');
                        // if (ui.value >= sliderConfig.config.range[1])
                        //     $('.slider-range-inverse').css('background','#009688');
                        this.update_handle_track_pos(event.target, (ui.value - sliderConfig.min) / (sliderConfig.max - sliderConfig.min) * 100)
                    }
                });
            }
            //$('.survey-slider > div').slider('value', sliderConfig.config.defaultValue);

        }
    }

    changeVocTitle(text) {
        $(".voc-title").html(text);
    }
    update_handle_track_pos(slider, ui_handle_pos) {

        const slider_range_inverse_width = (ui_handle_pos) + "%";
        $(slider).find(".slider-range-inverse").css("width", slider_range_inverse_width)
    }

    clearVoc() {
        $('.voc-checkbox').removeClass('active').removeAttr('style');
        $('input[name="voc"]').val("");
    }

    showVoc(answerid) {
        $.each(vocList[parseInt(answerid)], function (key, value) {
            $('.voc-wrapper').find('*[data-id="' + key + '"]').removeClass('stateOff');
        });
    }

    static fromJSON(serializedJson) {
        return Object.assign(new ExcitingMath(), JSON.parse(serializedJson))
    }

    scroll_to_class(element_class, removed_height) {
        var scroll_to = $(element_class).offset().top - removed_height;
        if ($(window).scrollTop() != scroll_to) {
            $('html, body').stop().animate({
                scrollTop: scroll_to
            }, 600);
        }
    }
}
