import * as Auth from './components/auth/SignIn';
import * as Errors from './components/errors/NotFinds';
import Home from './components/pages/Home';
import Brands from './components/pages/Brands';
import Products from './components/pages/Products';
import Repair from './components/pages/Repair';
import Map from './components/pages/Map';
import Process from './components/pages/Process';
import Orders from './components/pages/Orders';

export const  ROUTES = [
    {
        name: 'auth.signin',
        path: '/signin',
        component: Auth.SignIn,
        auth: false,
    },
    {
        name: 'home',
        path: '/',
        component: Home,
        auth : true,
    },
    {
        name: 'brands',
        path: '/brands',
        component: Brands,
        auth : true,
    },
    {
        name: 'products',
        path: '/products',
        component: Products,
        auth : true,
    },
    {
        name: 'repair',
        path: '/repair',
        component: Repair,
        auth : true,
    },
    {
        name: 'map',
        path: '/map',
        component: Map,
        auth : true,
    },
    {
        name: 'process',
        path: '/process',
        component: Process,
        auth : true,
    },
    {
        name: 'orders',
        path: '/orders',
        component: Orders,
        auth : true,
    },
    {
        name: 'errors.not-found',
        component: Errors.NotFinds,
    }
];