import React from "react";
import { AuthLayout } from "../layout/AuthLayout";
import { AppContext } from "../../appContext";
import Switch from "../core/form/Switch";
import "../core/elements/question.css";
import { ItemMeta } from "semantic-ui-react";

class Repair extends React.Component {
    static contextType = AppContext;
    constructor(props) {
        super(props);
        this.state = {
            questions: {},
            loading: true,
            answers: null,
        };
        this.handleSubmit = this.handleSubmit.bind(this);
    }

    componentDidMount() {
        this.getQuestions();
        if (this.context) this.state.appStatus = this.context.appStatus;
    }

    handleSubmitClick() {
        this.props.history.push("/products");
    }

    async getQuestions() {
        this.setState({ loading: true });

        if (this.context && Object.keys(this.context.content).length) {
            const product = this.context.status.product;
            try {
                const response = await axios.post(
                    "/request/getRepairQuestions",
                    { id: product }
                );
                this.setState({ loading: false, questions: response.data });
            } catch (error) {
                this.setState({ loading: false });
            }
        }
    }

    toggleSwitchHandle(item) {
        this.setState((prevState) => {
            let isUpdated = false;
            
            let answers = prevState.answers ? prevState.answers.map((value,index) => {
                if(value.id == item.id){
                    isUpdated = true;
                    return item;
                }
                return value;
            }) : [];
            if(!isUpdated){
                answers.push(item);
            }
            return {answers};
        });

    }

    handleSubmit(){
        this.state.appStatus({ key: "answers", value: this.state.answers });
        this.props.history.push("/map");
    }

    render() {
        const questions = this.state.questions;
        const logoSrc = "public/eqlid/logo-white.webp";
        const top = <img src={logoSrc} className="logo-img"></img>;

        return (
            <AuthLayout
                className="repairBox"
                top={!this.state.identified ? top : null}
                {...this.props}
            >
                <div>
                    {questions && Object.keys(questions).length > 0 ? (
                        <>
                            <div className="wrapper container800">
                                <div className="d-flex flex-wrap question-list">
                                    {questions.map((item, index) => (
                                        <div
                                            className="question-item"
                                            key={index}
                                        >
                                            <Switch
                                                theme="default"
                                                className="qi-container"
                                                label={item.title}
                                                item = {item}
                                                enabled={false}
                                                onStateChanged={
                                                    (item) => this.toggleSwitchHandle(item)
                                                }
                                            />
                                        </div>
                                    ))}
                                </div>
                                <div className="button-wrrapper">
                                    <button
                                        type="submit"
                                        className="button primary-box"
                                        onClick={this.handleSubmit}
                                    >
                                        مرحله بعد
                                    </button>
                                </div>
                            </div>
                        </>
                    ) : (
                        <div>در حال دریافت اطلاعات...</div>
                    )}
                </div>
            </AuthLayout>
        );
    }
}

export default Repair;
