import React from "react";
import { ShareLayout } from "../layout/ShareLayout";
import Product from "../core/elements/Product";
import { AppContext } from "../../appContext";

class Products extends React.Component {
    static contextType = AppContext;
    constructor(props) {
        super(props);
        this.state = {};
        this.handleProductClick = this.handleProductClick.bind(this);
    }

    componentDidMount(){
        if(this.context)
            this.state.appStatus = this.context.appStatus;
    }

    getProductsContext() {
        let products = [];
        if (this.context && Object.keys(this.context.content).length) {
            const brand = this.context.status.brand;
            const group = this.context.status.group;

            if (!brand || !group) {
                products = Object.values(this.context.content.brands).reduce(
                    (acc, val) => {
                        const newCon = Object.values(val.items).reduce(
                            (acc2, val2) =>
                                acc2.concat(Object.values(val2.items)),
                            []
                        );
                        return acc.concat(newCon);
                    },
                    []
                );
            } else {
                products = Object.values(
                    this.context.content.brands[brand].items[group].items
                );
            }
        }
        return products;
    }

    handleProductClick(item) {
        
        this.state.appStatus({ key: "product", value: item.id });
        if (this.context.status.service == 4) 
            this.props.history.push("/repair");
        else 
            this.props.history.push("/map");
    }

    render() {
        const products = this.getProductsContext();

        const top = <img className="logo-img"></img>;
        return (
            <ShareLayout
                className="form-signin"
                top={top}
                header="انتخاب محصول"
                {...this.props}
            >
                <div>
                    {Object.keys(products).length > 0 && (
                        <>
                            <div className="wrapper container800">
                                <div className="row no-gutters">
                                    {products.map((item, index) => (
                                        <Product
                                            item={item}
                                            key={index}
                                            onClick={(item) => this.handleProductClick(item)}
                                        />
                                    ))}
                                </div>
                            </div>
                        </>
                    )}
                </div>
            </ShareLayout>
        );
    }
}

export default Products;
