import React from 'react';
import { ShareLayout } from "../layout/ShareLayout";
import Product from "../core/elements/Product";
import { AppContext } from "../../appContext";
import "./process.css";

class Process extends React.Component{
    static contextType = AppContext;
    constructor(props){
        super(props);
        this.state = {
            result : true
        }
    }

   handleCancelClick(){
       this.props.history.push('/products');
   }

    render(){
        
        return ( 
            <>
                {this.state.result ? (
                    <>
                    <div className="processLayout">
                        <div className="header">
                            <span>در حال ارتباط با سرور جهت ثبت درخواست...</span>
                        </div>
                        <div className="logo">
                            <img src="/public/eqlid/logo.gif"/>
                        </div>
                        <div className="footer">
                            <p>با تمدید گارانتی محصولات خود، از صرف هزینه های سنگین و زمانبر جلوگیری کنید.</p>
                            <button className="button cancelBtn">لغو درخواست</button>
                        </div>
                    </div>
                    </>
                ) : 
                (
                    <div>Brand loading ....</div>
                )}
            </>
           
        );
    }
}

export default Process;


