import React from 'react';
import { ShareLayout } from "../layout/ShareLayout";
import Order from "../core/elements/Order";
import { AppContext } from "../../appContext";

class Orders extends React.Component{
    static contextType = AppContext;
    constructor(props){
        super(props);
        this.state = {
            orders: {},
        };
    }

   handleProductClick(){
       this.props.history.push('/products');
   }

   componentDidMount(){
        this.getOrders();
    }

   async getOrders(){
    this.setState({ loading: true });
    
    try {
         const response = await axios.post("/request/getOpenRequests");
         this.setState({ loading: false , orders: response.data});
    } catch (error) {
         this.setState({ loading: false });
    }
     
}

    render(){
        let orders = this.state.orders;
        
        const top =  <img  className="logo-img"></img>;
        return (
            <ShareLayout className="form-signin" top={ top } header=" درخواست های جاری">
            <div>
                {orders && Object.keys(orders).length > 0 ? (
                    <>
                    <div className="wrapper container800">
                        <div className="row no-gutters">
                            {orders.map((item, index) => (
                                <Order item={item} key={index} onClick={this.handleProductClick}/>
                            ))}
                        </div>
                    </div>
                    
                    </>
                ) : 
                (
                    <div>Brand loading ....</div>
                )}
            </div>
            </ShareLayout>
        );
    }
}

export default Orders;


