import React from "react";
import { MainLayout } from "../layout/MainLayout";
import Carousel from "../core/elements/Carousel";
import Promotion from "../core/elements/Promotion";
import Devices from "../core/elements/Devices";
import { AppContext } from "../../appContext";
import Order from "../core/elements/Order";

class Home extends React.Component {
    static contextType = AppContext;
    constructor(props) {
        super(props);
        this.state = {
            content: {},
            user: {},
            orders: {},
        };
    }

    componentDidMount() {
        this.getOrders();
    }

    componentDidUpdate() {
        this.state.content = this.context.content;
        this.state.user = this.context.user;
    }

    async getOrders() {
        this.setState({ loading: true });

        try {
            const response = await axios.post("/request/getOpenRequests");
            this.setState({ loading: false, orders: response.data });
        } catch (error) {
            this.setState({ loading: false });
        }
    }

    handleOrderClick() {}

    render() {
        
        const orders = this.state.orders;
        const user = this.state.user ?? {};
        const content = this.state.content ?? {};
        

        const top = <img className="logo-img"></img>;
        return (
            <MainLayout
                className="form-signin"
                top={top}
                user={user}
                {...this.props}
            >
                <div>
                    {Object.keys(content).length > 0 && (
                        <>
                            <Promotion
                                items={content.promotions.items}
                                {...this.props}
                            />
                        </>
                    )}
                    {Object.keys(orders).length > 0 && (
                        <div className="wrapper container800">
                            <div className="row no-gutters">
                                {orders.map((item, index) => (
                                    <Order
                                        item={item}
                                        key={index}
                                        onClick={this.handleOrderClick}
                                    />
                                ))}
                            </div>
                        </div>
                    )}
                    {('devices' in user && Object.keys(user.devices).length > 0) && (
                        <Devices items={user.devices} />
                    )}

                    {Object.keys(content).length > 0 && (
                        <>
                        <Carousel
                                slides={content.sections.items}
                            />
                        </>
                    )}
                </div>
            </MainLayout>
        );
    }
}

export default Home;
