import React from 'react';
import { ShareLayout } from "../layout/ShareLayout";
import Brand from "../core/elements/Brand";
import { AppContext } from "../../appContext";

class Brands extends React.Component{
    static contextType = AppContext;
    constructor(props){
        super(props);
    }

   handleBrandClick(){
       this.props.history.push('/product');
   }

    render(){
        
        let brands = {};
        if(this.context) brands =  this.context.content.brands;
        
        const top =  <img  className="logo-img"></img>;
        return (
            <ShareLayout className="form-signin" top={ top } header="انتخاب برند" {...this.props}>
            <div>
                {brands && Object.keys(brands).length > 0 ? (
                    <>
                    <div className="wrapper container800">
                        <div className="row no-gutters">
                            {Object.values(brands).map((item, index) => (
                                <Brand item={item} key={index} onClick={this.handleBrandClick}  {...this.props}/>
                            ))}
                        </div>
                    </div>
                    
                    </>
                ) : 
                (
                    <div>Brand loading ....</div>
                )}
            </div>
            </ShareLayout>
        );
    }
}

export default Brands;


