import React, { useState, useEffect, useContext } from "react";
import { AppContext } from "../../appContext";


export class ShareLayout extends React.Component {
    constructor(props) {
        super(props);
        this.handleHomeClick = this.handleHomeClick.bind(this);
        this.handleBackClick = this.handleBackClick.bind(this);
    }

    handleHomeClick(e){
        e.preventDefault();
        console.log('alo');
        this.props.history.push('/');
    }

    handleBackClick(e){
        e.preventDefault();
        this.props.history.goBack();
    }

    render() {
        
        const { top, children, loading, message,header } = this.props;
        let styleUp = {};
        if(!top) styleUp = {'height' : '0'};
        
        return (
            <div className="pc-1">
                <div className="pc-1-primary">
                    <div className="ps-up" style={styleUp}>
                        <div className="pc-up-header">
                            <button onClick={this.handleBackClick} className="settingBtn circleBtn">
                                <i>
                                    <svg width="24" height="24" color="#333" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><g fill="none" fillRule="evenodd"><path d="M0 0h24v24H0z"></path><path d="M8.293 4.707a1 1 0 011.414-1.414l8 8a1 1 0 010 1.414l-8 8a1 1 0 11-1.414-1.414L15.586 12 8.293 4.707z" fill="currentColor" fillRule="nonzero"></path></g></svg>
                                </i>
                            </button>
                            <div className="bold font-xl">{header}</div>
                            <button className="settingBtn circleBtn" onClick={this.handleHomeClick}>
                                <i>
                                <svg width="24" height="24" color="#333" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><g fill="none" fillRule="evenodd"><path d="M0 0h24v24H0z"></path><path d="M18.5 19a.5.5 0 00.5-.5V9.394c0-.057.005-.114.014-.169l-6.44-4.208a1 1 0 00-1.147 0L4.986 9.225c.01.055.014.112.014.17V18.5a.5.5 0 00.5.5H9v-5a1 1 0 011-1h4a1 1 0 011 1v5h3.5zm2.5-.5a2.5 2.5 0 01-2.5 2.5H14a1 1 0 01-1-1v-5h-2v5a1 1 0 01-1 1H5.5A2.5 2.5 0 013 18.5v-8.106c-.978 0-1.374-1.258-.573-1.819l7.853-5.197a3 3 0 013.44 0l7.853 5.197c.801.56.405 1.82-.573 1.82V18.5z" fill="currentColor" fillRule="nonzero"></path></g></svg>
                                </i>
                            </button>
                        </div>
                        
                    </div>
                    <div className="pc-down">
                        <div className="layout-box">{children}</div>
                    </div>
                </div>
            </div>
        );
    }
}
