import React, { useState, useEffect, useContext } from "react";
import { AppContext } from "../../appContext";


export class MainLayout extends React.Component {
    constructor(props) {
        super(props);
        this.handleHomeClick = this.handleHomeClick.bind(this);
        this.handleBackClick = this.handleBackClick.bind(this);
    }

    handleHomeClick(e){
        e.preventDefault();
        this.props.history.push('/');
    }

    handleBackClick(e){
        e.preventDefault();
        this.props.history.goBack();
    }

    render() {
        
        const { top, children, loading, message, user } = this.props;
        let styleUp = {};
        if(!top) styleUp = {'height' : '0'};
        
        return (
            <div className="pc-1">
                <div className="pc-1-primary">
                    <div className="pc-up tertiary-box" style={styleUp}>
                        <div className="pc-up-header">
                            <button onClick={this.handleBackClick} className="circleBtn backBtn" tabIndex="0" type="button" aria-label="favorite">
                                <svg className="svgIcon" focusable="false" viewBox="0 0 500 500" aria-hidden="true"><path d="M300 450c-6.4 0-12.8-2.4-17.7-7.3-9.8-9.8-9.8-25.6 0-35.4L414.6 275H25c-13.8 0-25-11.2-25-25s11.2-25 25-25h389.6L282.3 92.7c-9.8-9.8-9.8-25.6 0-35.4s25.6-9.8 35.4 0l175 175c2.4 2.4 4.2 5.2 5.4 8.2 1.2 2.9 1.9 6.1 1.9 9.4v.1c0 3.3-.7 6.5-1.9 9.4-1.2 3-3 5.7-5.4 8.2l-175 175c-4.9 5-11.3 7.4-17.7 7.4z"></path></svg>
                            </button>
                            <button onClick={this.handleHomeClick} className="circleBtn backBtn" tabIndex="0" type="button" aria-label="favorite">
                                <svg width="24" height="24" color="#333" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><g fill="none" fillRule="evenodd"><path d="M0 0h24v24H0z"></path><path d="M15 14a5 5 0 015 5v2a1 1 0 01-2 0v-2a3 3 0 00-3-3H9a3 3 0 00-3 3v2a1 1 0 01-2 0v-2a5 5 0 015-5h6zM12 2a5 5 0 110 10 5 5 0 010-10zm0 2a3 3 0 100 6 3 3 0 000-6z" fill="currentColor" fillRule="nonzero"></path></g></svg>
                            </button>
                        </div>
                        <div className="pc-up-content">
                            <h2 className="pc-up-mobile">{user.mobile}</h2>
                            <div className="pc-up-container">
                                <div className="pc-up-name-wrapper">
                                    <label className="punwsh pc-up-name">{user.name}</label>
                                    <label className="pc-up-name-posotion punwsh">موقعیت : {user.location ?? 'تهران'}</label>
                                </div>
                                <div className="pc-up-request-wrapper">
                                    <div className="pc-up-name-wrapper align-items-end">
                                        <label className="punwsh "> 3 عدد</label>
                                        <label className="pc-up-name-posotion punwsh">درخواست های من</label>
                                    </div>
                                    <div className="requestImg">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                            <path fill="#FFF" fillRule="nonzero" d="M15.956 22L6 12.044 16.044 2l.978.889-9.155 9.155 9.066 8.978z"/>
                                        </svg>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                    <div className="pc-down">
                        <div className="layout-box">{children}</div>
                    </div>
                </div>
            </div>
        );
    }
}
