import React, { useState, useEffect, useContext } from "react";
import { AppContext } from "../../appContext";
import classnames from 'classnames';

export class AuthLayout extends React.Component {
    constructor(props) {
        super(props);
    }

    render() {
        const { nightMode } = this.context;
        const { top, children, className, loading, message } = this.props;
        let styleUp = {};
        if(!top) styleUp = {'height' : '0'};

        const boxClasses = classnames(
            `pb-1`,
            className
          )
        
        return (
            <div className={boxClasses}>
                <div className="primary-box pb-1-primary">
                    <div className="pb-up" style={styleUp}>{top}</div>
                    <div className="pb-down secondary-box">
                        <div className="layout-box">{children}</div>
                    </div>
                </div>
            </div>
        );
    }
}

AuthLayout.contextType = AppContext;
