import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

export default class Switch extends React.Component {
    
      static propTypes = {
        theme: PropTypes.string,
        enabled: PropTypes.oneOfType([
          PropTypes.bool,
          PropTypes.func
        ]),
        onStateChanged: PropTypes.func,
        onClick: PropTypes.func
      }

    constructor(props) {
      super(props);
      this.state = {
        enabled : this.props.enabled
      }
     
    }
  
    toggleSwitch = event => {
      event.persist();
      event.preventDefault();
  
      const { onClick, onStateChanged, item} = this.props;
  
      this.setState({ enabled: !this.state.enabled }, () => {
        const state = this.state;
  
        // Augument the event object with SWITCH_STATE
        const switchEvent = Object.assign(event, { SWITCH_STATE: state });
        const switchState = Object.assign(state,item);
        // Execute the callback functions
        onClick && onClick(switchEvent);
        onStateChanged && onStateChanged(switchState);
      });
    }
  
    render() {
      const { enabled } = this.state;
  
      // Isolate special props and store the remaining as restProps
      const { enabled: _enabled, theme, onClick, className, onStateChanged, label, ...restProps } = this.props;
  
      // Use default as a fallback theme if valid theme is not passed
      const switchTheme = (theme && typeof theme === 'string') ? theme : 'default';
  
      const switchClasses = classnames(
        `switch switch--${switchTheme}`,
        'd-flex'
      )
  
      const togglerClasses = classnames(
        'switch-toggle',
        `switch-toggle--${enabled ? 'on' : 'off'}`
      )
  
      return (
        <>
        {label ? (
          <div className={className} onClick={this.toggleSwitch}>
            <div>{label}</div>
            <div className={switchClasses} {...restProps}>
              <div className={togglerClasses}></div>
            </div>
          </div>
        ) : (
          <div className={switchClasses + ' ' + className} onClick={this.toggleSwitch} {...restProps}>
            <div className={togglerClasses}></div>
          </div>
        )}
        </>
      )
    }
  }