import React from "react";
// import Swiper core and required components
import Swiper from "swiper";
import "swiper/dist/css/swiper.min.css";
import "./timePicker.css";

export default class TimePicker extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            loading: true,
        };
        this.swiperMonth = React.createRef();
        this.swiperTime = React.createRef();
    }

    componentDidMount() {
        this.swiperMonth.current = new Swiper(".month", {
            slidesPerView: 3,
            mousewheel: true,
            direction: "vertical",
            slideToClickedSlide: true,
            centeredSlides: true,
        });
        this.swiperMonth.current = new Swiper(".time", {
            slidesPerView: 3,
            mousewheel: true,
            direction: "vertical",
            slideToClickedSlide: true,
            centeredSlides: true,
        });
    }

    componentDidUpdate() {
        if (this.props.slides && Object.keys(this.props.slides).length) {
            this.setState({ loading: false });
        }
    }

    render() {
        return (
            <div className="timePicker">
                <div className="cxNfXK">
                    <div className="picker-container">
                        <div className="swiper-container month">
                            <div className="swiper-wrapper">
                                <div className="swiper-slide">5 بهمن</div>
                                <div className="swiper-slide">6 بهمن</div>
                                <div className="swiper-slide">7 بهمن</div>
                                <div className="swiper-slide">8 بهمن</div>
                                <div className="swiper-slide">9 بهمن</div>
                                <div className="swiper-slide">10 بهمن</div>
                                <div className="swiper-slide">11 بهمن</div>
                                <div className="swiper-slide">12 بهمن</div>
                                <div className="swiper-slide">13 بهمن</div>
                            </div>
                        </div>
                        <div className="picker-vizor"></div>
                    </div>
                </div>
                <div className="cxNfXK">
                    <div className="picker-container">
                        <div className="swiper-container time">
                            <div className="swiper-wrapper">
                                <div className="swiper-slide">7 صبح الی 12 ظهر</div>
                                <div className="swiper-slide">12 ظهر الی 4 عصر</div>
                                <div className="swiper-slide">4 عصر الی 8 شب</div>
                                <div className="swiper-slide">8 شب الی 12 شب</div>
                            </div>
                        </div>
                        <div className="picker-vizor"></div>
                    </div>
                </div>
            </div>
        );
    }
}
