import React from "react";
import "./promotion.css";
import { AppContext } from "../../../appContext";


export default class Promotion extends React.Component {
    static contextType = AppContext;
    constructor(props) {
        super(props);
        this.state = {
            loading: true
        };
    }

    componentDidMount() {
        if (this.props.items && Object.keys(this.props.items).length) {
            this.setState({ loading: false });
        }
        
        if(this.context)
            this.state.appStatus = this.context.appStatus;
    }

    handleClick(item){
        this.state.appStatus({key: 'service', value: item.id});
        this.props.history.push('/brands');
    }

    render() {
        const items = this.props.items;
        return (
            <>
                {Object.keys(items).length < 1 ? (
                    <div>loading...</div>
                ) : (
                    <div className="wrapper">
                        <div className="row-wrapper box">
                        <div className="row no-gutters">
                            {items.map((item, index) => (
                                <div className="col-3 col-md-3" key={index}>
                                    
                                    <div className="prom-item-container" onClick={()=>this.handleClick(item)}>
                                        <div className="prom-circle" 
                                        style={{
                                            backgroundColor: item.background_color,
                                            borderColor: item.background_border_color
                                        }}
                                        >
                                            <img
                                                src={item.icon}
                                                alt="پنل کاربری"
                                                width="40px"
                                                className="icon-image profileImg"
                                            />
                                        </div>
                                        <div className="prom-content">
                                            <h3>{item.title}</h3>
                                            <p>{item.description}</p>
                                        </div>
                                    </div>
                                
                                </div>
                            ))}
                        </div>
                        </div>
                    </div>
                )}
            </>
        );
    }
}
